/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import org.orekit.files.ccsds.definitions.AdMethodType;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.acm.AcmParser;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceType;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDetermination;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeElementsType;
import org.orekit.files.ccsds.ndm.adm.acm.RateElementsType;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;

public enum AttitudeDeterminationKey {
    COMMENT((token, parser, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    AD_ID((token, parser, context, container) -> token.processAsFreeTextString(container::setId)),
    AD_PREV_ID((token, parser, context, container) -> token.processAsFreeTextString(container::setPrevId)),
    AD_METHOD((token, parser, context, container) -> token.processAsEnum(AdMethodType.class, container::setMethod)),
    ATTITUDE_SOURCE((token, parser, context, container) -> token.processAsFreeTextString(container::setSource)),
    EULER_ROT_SEQ((token, parser, context, container) -> token.processAsRotationOrder(container::setEulerRotSeq)),
    NUMBER_STATES((token, parser, context, container) -> token.processAsInteger(container::setNbStates)),
    ATTITUDE_STATES((token, parser, context, container) -> token.processAsEnum(AttitudeElementsType.class, container::setAttitudeStates)),
    COV_TYPE((token, parser, context, container) -> token.processAsEnum(AttitudeCovarianceType.class, container::setCovarianceType)),
    REF_FRAME_A((token, parser, context, container) -> token.processAsFrame(container.getEndpoints()::setFrameA, context, true, true, false)),
    REF_FRAME_B((token, parser, context, container) -> token.processAsFrame(container.getEndpoints()::setFrameB, context, false, false, true)),
    RATE_STATES((token, parser, context, container) -> token.processAsEnum(RateElementsType.class, container::setRateStates)),
    SIGMA_U((token, parser, context, container) -> token.processAsDouble(Units.DEG_PER_S_3_2, context.getParsedUnitsBehavior(), container::setSigmaU)),
    SIGMA_V((token, parser, context, container) -> token.processAsDouble(Units.DEG_PER_S_1_2, context.getParsedUnitsBehavior(), container::setSigmaV)),
    RATE_PROCESS_NOISE_STDDEV((token, parser, context, container) -> token.processAsDouble(Units.DEG_PER_S_3_2, context.getParsedUnitsBehavior(), container::setRateProcessNoiseStdDev)),
    SENSOR((token, parser, context, container) -> parser.manageAttitudeDeterminationSensorSection(token.getType() == TokenType.START));

    private final transient TokenProcessor processor;

    private AttitudeDeterminationKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, AcmParser parser, ContextBinding context, AttitudeDetermination container) {
        return this.processor.process(token, parser, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, AcmParser var2, ContextBinding var3, AttitudeDetermination var4);
    }
}

