/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.AdMethodType;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndpoints;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceType;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationSensor;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeElementsType;
import org.orekit.files.ccsds.ndm.adm.acm.RateElementsType;
import org.orekit.files.ccsds.section.CommentsContainer;

public class AttitudeDetermination
extends CommentsContainer {
    private final AttitudeEndpoints endpoints = new AttitudeEndpoints();
    private String id;
    private String prevId;
    private AdMethodType method;
    private String source;
    private RotationOrder eulerRotSeq;
    private int nbStates = -1;
    private AttitudeElementsType attitudeStates;
    private AttitudeCovarianceType covarianceType;
    private RateElementsType rateStates;
    private double sigmaU;
    private double sigmaV;
    private double rateProcessNoiseStdDev;
    private List<AttitudeDeterminationSensor> sensorsUsed = new ArrayList<AttitudeDeterminationSensor>();

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull((Object)this.attitudeStates, AttitudeDeterminationKey.ATTITUDE_STATES.name());
        this.endpoints.checkExternalFrame(AttitudeDeterminationKey.REF_FRAME_A, AttitudeDeterminationKey.REF_FRAME_B);
        for (int number = 1; number <= this.sensorsUsed.size(); ++number) {
            AttitudeDeterminationSensor sensor = this.findSensor(number);
            if (sensor == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_SENSOR_INDEX, number);
            }
            sensor.validate(version);
        }
    }

    private AttitudeDeterminationSensor findSensor(int number) {
        for (AttitudeDeterminationSensor sensor : this.sensorsUsed) {
            if (sensor.getSensorNumber() != number) continue;
            return sensor;
        }
        return null;
    }

    public AttitudeEndpoints getEndpoints() {
        return this.endpoints;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPrevId() {
        return this.prevId;
    }

    public void setPrevId(String prevId) {
        this.prevId = prevId;
    }

    public AdMethodType getMethod() {
        return this.method;
    }

    public void setMethod(AdMethodType method) {
        this.method = method;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public RotationOrder getEulerRotSeq() {
        return this.eulerRotSeq;
    }

    public void setEulerRotSeq(RotationOrder eulerRotSeq) {
        this.eulerRotSeq = eulerRotSeq;
    }

    public int getNbStates() {
        return this.nbStates;
    }

    public void setNbStates(int nbStates) {
        this.nbStates = nbStates;
    }

    public AttitudeElementsType getAttitudeStates() {
        return this.attitudeStates;
    }

    public void setAttitudeStates(AttitudeElementsType attitudeStates) {
        this.attitudeStates = attitudeStates;
    }

    public AttitudeCovarianceType getCovarianceType() {
        return this.covarianceType;
    }

    public void setCovarianceType(AttitudeCovarianceType covarianceType) {
        this.covarianceType = covarianceType;
    }

    public RateElementsType getRateStates() {
        return this.rateStates;
    }

    public void setRateStates(RateElementsType rateStates) {
        this.rateStates = rateStates;
    }

    public double getSigmaU() {
        return this.sigmaU;
    }

    public void setSigmaU(double sigmaU) {
        this.sigmaU = sigmaU;
    }

    public double getSigmaV() {
        return this.sigmaV;
    }

    public void setSigmaV(double sigmaV) {
        this.sigmaV = sigmaV;
    }

    public double getRateProcessNoiseStdDev() {
        return this.rateProcessNoiseStdDev;
    }

    public void setRateProcessNoiseStdDev(double rateProcessNoiseStdDev) {
        this.rateProcessNoiseStdDev = rateProcessNoiseStdDev;
    }

    public List<AttitudeDeterminationSensor> getSensorsUsed() {
        return Collections.unmodifiableList(this.sensorsUsed);
    }

    public void addSensor(AttitudeDeterminationSensor sensor) {
        for (AttitudeDeterminationSensor existing : this.sensorsUsed) {
            if (sensor.getSensorNumber() != existing.getSensorNumber()) continue;
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_SENSOR_INDEX_ALREADY_USED, sensor.getSensorNumber());
        }
        this.sensorsUsed.add(sensor);
    }
}

