/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.io.IOException;
import java.util.List;
import org.hipparchus.linear.DiagonalMatrix;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.adm.acm.AcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovariance;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistory;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistoryMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistoryMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class AttitudeCovarianceHistoryWriter
extends AbstractWriter {
    private final AttitudeCovarianceHistory history;
    private final TimeConverter timeConverter;

    AttitudeCovarianceHistoryWriter(AttitudeCovarianceHistory covarianceHistory, TimeConverter timeConverter) {
        super(AcmDataSubStructureKey.cov.name(), AcmDataSubStructureKey.COV.name());
        this.history = covarianceHistory;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        AttitudeCovarianceHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(AttitudeCovarianceHistoryMetadataKey.COV_ID.name(), metadata.getCovID(), null, false);
        generator.writeEntry(AttitudeCovarianceHistoryMetadataKey.COV_PREV_ID.name(), metadata.getCovPrevID(), null, false);
        generator.writeEntry(AttitudeCovarianceHistoryMetadataKey.COV_BASIS.name(), metadata.getCovBasis(), null, false);
        generator.writeEntry(AttitudeCovarianceHistoryMetadataKey.COV_BASIS_ID.name(), metadata.getCovBasisID(), null, false);
        if (metadata.getCovReferenceFrame() != null) {
            generator.writeEntry(AttitudeCovarianceHistoryMetadataKey.COV_REF_FRAME.name(), metadata.getCovReferenceFrame().getName(), null, false);
        }
        generator.writeEntry(AttitudeCovarianceHistoryMetadataKey.COV_TYPE.name(), metadata.getCovType(), false);
        List<Unit> units = metadata.getCovType().getUnits();
        for (AttitudeCovariance covariance : this.history.getCovariances()) {
            DiagonalMatrix matrix = covariance.getMatrix();
            StringBuilder line = new StringBuilder();
            line.append(generator.dateToString(this.timeConverter, covariance.getDate()));
            for (int k = 0; k < units.size(); ++k) {
                line.append(' ');
                line.append(AccurateFormatter.format(units.get(k).fromSI(matrix.getEntry(k, k))));
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.writeEntry("covLine", line.toString(), null, true);
                continue;
            }
            generator.writeRawData(line);
            generator.newLine();
        }
    }
}

