/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.List;
import org.hipparchus.linear.DiagonalMatrix;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.units.Unit;

public class AttitudeCovariance
implements TimeStamped {
    private final AttitudeCovarianceType type;
    private final AbsoluteDate date;
    private final DiagonalMatrix matrix;

    public AttitudeCovariance(AttitudeCovarianceType type, AbsoluteDate date, String[] fields, int first) {
        List<Unit> units = type.getUnits();
        this.type = type;
        this.date = date;
        this.matrix = new DiagonalMatrix(units.size());
        for (int k = 0; k < this.matrix.getRowDimension(); ++k) {
            this.matrix.setEntry(k, k, units.get(k).toSI(Double.parseDouble(fields[first + k])));
        }
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public DiagonalMatrix getMatrix() {
        return this.matrix;
    }

    public AttitudeCovarianceType getType() {
        return this.type;
    }
}

