/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmHeader;
import org.orekit.files.ccsds.ndm.adm.acm.Acm;
import org.orekit.files.ccsds.ndm.adm.acm.AcmData;
import org.orekit.files.ccsds.ndm.adm.acm.AcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadataWriter;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistory;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistoryWriter;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationWriter;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuver;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuverWriter;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudePhysicalPropertiesWriter;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistory;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistoryWriter;
import org.orekit.files.ccsds.ndm.odm.UserDefinedWriter;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.IERSConventions;

public class AcmWriter
extends AbstractMessageWriter<AdmHeader, Segment<AcmMetadata, AcmData>, Acm> {
    public static final double CCSDS_ACM_VERS = 2.0;
    public static final int KVN_PADDING_WIDTH = 33;

    public AcmWriter(IERSConventions conventions, DataContext dataContext) {
        super("acm", "CCSDS_ACM_VERS", 2.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> null, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    protected void writeSegmentContent(Generator generator, double formatVersion, Segment<AcmMetadata, AcmData> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        AcmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, metadata::getEpochT0, metadata::getTimeSystem, () -> 0.0, () -> 1.0));
        new AcmMetadataWriter(metadata, this.getTimeConverter()).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        if (segment.getData().getAttitudeBlocks() != null && !segment.getData().getAttitudeBlocks().isEmpty()) {
            for (AttitudeStateHistory attitudeStateHistory : segment.getData().getAttitudeBlocks()) {
                new AttitudeStateHistoryWriter(attitudeStateHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getPhysicBlock() != null) {
            new AttitudePhysicalPropertiesWriter(segment.getData().getPhysicBlock()).write(generator);
        }
        if (segment.getData().getCovarianceBlocks() != null && !segment.getData().getCovarianceBlocks().isEmpty()) {
            for (AttitudeCovarianceHistory attitudeCovarianceHistory : segment.getData().getCovarianceBlocks()) {
                new AttitudeCovarianceHistoryWriter(attitudeCovarianceHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getManeuverBlocks() != null && !segment.getData().getManeuverBlocks().isEmpty()) {
            for (AttitudeManeuver attitudeManeuver : segment.getData().getManeuverBlocks()) {
                new AttitudeManeuverWriter(attitudeManeuver).write(generator);
            }
        }
        if (segment.getData().getAttitudeDeterminationBlock() != null) {
            new AttitudeDeterminationWriter(segment.getData().getAttitudeDeterminationBlock()).write(generator);
        }
        if (segment.getData().getUserDefinedBlock() != null) {
            new UserDefinedWriter(AcmDataSubStructureKey.user.name(), AcmDataSubStructureKey.USER.name(), segment.getData().getUserDefinedBlock()).write(generator);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

