/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmHeader;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AdmParser;
import org.orekit.files.ccsds.ndm.adm.acm.Acm;
import org.orekit.files.ccsds.ndm.adm.acm.AcmData;
import org.orekit.files.ccsds.ndm.adm.acm.AcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovariance;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistory;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistoryMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDetermination;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationSensor;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationSensorKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuver;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuverKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudePhysicalProperties;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudePhysicalPropertiesKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeState;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistory;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistoryMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.KvnStructureProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.lexical.UserDefinedXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.files.general.AttitudeEphemerisFileParser;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class AcmParser
extends AdmParser<Acm, AcmParser>
implements AttitudeEphemerisFileParser<Acm> {
    private static final Pattern SPLIT_AT_BLANKS = Pattern.compile("\\s+");
    private AdmHeader header;
    private AcmMetadata metadata;
    private ContextBinding context;
    private List<AttitudeStateHistory> attitudeBlocks;
    private AttitudeStateHistoryMetadata currentAttitudeStateHistoryMetadata;
    private List<AttitudeState> currentAttitudeStateHistory;
    private AttitudePhysicalProperties physicBlock;
    private List<AttitudeCovarianceHistory> covarianceBlocks;
    private AttitudeCovarianceHistoryMetadata currentCovarianceHistoryMetadata;
    private List<AttitudeCovariance> currentCovarianceHistory;
    private List<AttitudeManeuver> maneuverBlocks;
    private AttitudeManeuver currentManeuver;
    private AttitudeDetermination attitudeDeterminationBlock;
    private AttitudeDeterminationSensor attitudeDeterminationSensorBlock;
    private UserDefined userDefinedBlock;
    private ProcessingState structureProcessor;

    public AcmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, ParsedUnitsBehavior parsedUnitsBehavior, Function<ParseToken, List<ParseToken>>[] filters) {
        super("acm", "CCSDS_ACM_VERS", conventions, simpleEOP, dataContext, null, parsedUnitsBehavior, filters);
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        Map<String, XmlTokenBuilder> builders = super.getSpecialXmlElementsBuilders();
        builders.put("USER_DEFINED", new UserDefinedXmlTokenBuilder());
        return builders;
    }

    @Override
    public Acm parse(DataSource source) {
        return (Acm)this.parseMessage(source);
    }

    @Override
    public AdmHeader getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new AdmHeader();
        this.metadata = null;
        this.context = null;
        this.attitudeBlocks = null;
        this.physicBlock = null;
        this.covarianceBlocks = null;
        this.maneuverBlocks = null;
        this.attitudeDeterminationBlock = null;
        this.userDefinedBlock = null;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("acm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new KvnStructureProcessingState(this);
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new AcmMetadata(this.getDataContext());
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this.metadata::getEpochT0, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.validate(this.header.getFormatVersion());
        this.anticipateNext(this::processDataSubStructureToken);
        return true;
    }

    @Override
    public boolean prepareData() {
        this.anticipateNext(this::processDataSubStructureToken);
        return true;
    }

    @Override
    public boolean inData() {
        return true;
    }

    @Override
    public boolean finalizeData() {
        return true;
    }

    boolean manageAttitudeStateSection(boolean starting) {
        if (starting) {
            if (this.attitudeBlocks == null) {
                this.attitudeBlocks = new ArrayList<AttitudeStateHistory>();
            }
            this.currentAttitudeStateHistoryMetadata = new AttitudeStateHistoryMetadata();
            this.currentAttitudeStateHistory = new ArrayList<AttitudeState>();
            this.anticipateNext(this::processAttitudeStateToken);
        } else {
            this.anticipateNext(this.structureProcessor);
            this.attitudeBlocks.add(new AttitudeStateHistory(this.currentAttitudeStateHistoryMetadata, this.currentAttitudeStateHistory));
        }
        return true;
    }

    boolean managePhysicalPropertiesSection(boolean starting) {
        if (starting) {
            this.physicBlock = new AttitudePhysicalProperties(this.metadata.getEpochT0());
            this.anticipateNext(this::processPhysicalPropertyToken);
        } else {
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    boolean manageCovarianceHistorySection(boolean starting) {
        if (starting) {
            if (this.covarianceBlocks == null) {
                this.covarianceBlocks = new ArrayList<AttitudeCovarianceHistory>();
            }
            this.currentCovarianceHistoryMetadata = new AttitudeCovarianceHistoryMetadata();
            this.currentCovarianceHistory = new ArrayList<AttitudeCovariance>();
            this.anticipateNext(this::processCovarianceToken);
        } else {
            this.anticipateNext(this.structureProcessor);
            this.covarianceBlocks.add(new AttitudeCovarianceHistory(this.currentCovarianceHistoryMetadata, this.currentCovarianceHistory));
            this.currentCovarianceHistoryMetadata = null;
            this.currentCovarianceHistory = null;
        }
        return true;
    }

    boolean manageManeuversSection(boolean starting) {
        if (starting) {
            if (this.maneuverBlocks == null) {
                this.maneuverBlocks = new ArrayList<AttitudeManeuver>();
            }
            this.currentManeuver = new AttitudeManeuver();
            this.anticipateNext(this::processManeuverToken);
        } else {
            this.anticipateNext(this.structureProcessor);
            this.maneuverBlocks.add(this.currentManeuver);
            this.currentManeuver = null;
        }
        return true;
    }

    boolean manageAttitudeDeterminationSection(boolean starting) {
        if (starting) {
            this.attitudeDeterminationBlock = new AttitudeDetermination();
            this.anticipateNext(this::processAttitudeDeterminationToken);
        } else {
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    boolean manageAttitudeDeterminationSensorSection(boolean starting) {
        if (starting) {
            this.attitudeDeterminationSensorBlock = new AttitudeDeterminationSensor();
            this.anticipateNext(this::processAttitudeDeterminationSensorToken);
        } else {
            this.anticipateNext(this::processDataSubStructureToken);
        }
        return true;
    }

    boolean manageUserDefinedParametersSection(boolean starting) {
        if (starting) {
            this.userDefinedBlock = new UserDefined();
            this.anticipateNext(this::processUserDefinedToken);
        } else {
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    @Override
    public Acm build() {
        if (this.userDefinedBlock != null && this.userDefinedBlock.getParameters().isEmpty()) {
            this.userDefinedBlock = null;
        }
        AcmData data = new AcmData(this.attitudeBlocks, this.physicBlock, this.covarianceBlocks, this.maneuverBlocks, this.attitudeDeterminationBlock, this.userDefinedBlock);
        data.validate(this.header.getFormatVersion());
        return new Acm(this.header, Collections.singletonList(new Segment<AcmMetadata, AcmData>(this.metadata, data)), this.getConventions(), this.getDataContext());
    }

    private boolean processMetadataToken(ParseToken token) {
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return AdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return AcmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeC) {
                    return false;
                }
            }
        }
    }

    private boolean processDataSubStructureToken(ParseToken token) {
        try {
            return token.getName() != null && AcmDataSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processAttitudeStateToken(ParseToken token) {
        if (token.getName() != null && !token.getName().equals("attLine")) {
            try {
                return AttitudeStateHistoryMetadataKey.valueOf(token.getName()).process(token, this.context, this.currentAttitudeStateHistoryMetadata);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        if (this.currentAttitudeStateHistory.isEmpty()) {
            this.currentAttitudeStateHistoryMetadata.validate(this.header.getFormatVersion());
            this.anticipateNext(this::processDataSubStructureToken);
        }
        if (token.getType() == TokenType.START || token.getType() == TokenType.STOP) {
            return true;
        }
        try {
            String[] fields = SPLIT_AT_BLANKS.split(token.getRawContent().trim());
            AbsoluteDate epoch = this.context.getTimeSystem().getConverter(this.context).parse(fields[0]);
            return this.currentAttitudeStateHistory.add(new AttitudeState(this.currentAttitudeStateHistoryMetadata.getAttitudeType(), this.currentAttitudeStateHistoryMetadata.getRateType(), epoch, fields, 1));
        }
        catch (NumberFormatException | OrekitIllegalArgumentException e) {
            throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
        }
    }

    private boolean processPhysicalPropertyToken(ParseToken token) {
        this.anticipateNext(this::processDataSubStructureToken);
        try {
            return token.getName() != null && AttitudePhysicalPropertiesKey.valueOf(token.getName()).process(token, this.context, this.physicBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processCovarianceToken(ParseToken token) {
        if (token.getName() != null && !token.getName().equals("covLine")) {
            try {
                return AttitudeCovarianceHistoryMetadataKey.valueOf(token.getName()).process(token, this.context, this.currentCovarianceHistoryMetadata);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        if (this.currentCovarianceHistory.isEmpty()) {
            this.currentCovarianceHistoryMetadata.validate(this.header.getFormatVersion());
            this.anticipateNext(this::processDataSubStructureToken);
        }
        if (token.getType() == TokenType.START || token.getType() == TokenType.STOP) {
            return true;
        }
        try {
            String[] fields = SPLIT_AT_BLANKS.split(token.getRawContent().trim());
            this.currentCovarianceHistory.add(new AttitudeCovariance(this.currentCovarianceHistoryMetadata.getCovType(), this.context.getTimeSystem().getConverter(this.context).parse(fields[0]), fields, 1));
            return true;
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
        }
    }

    private boolean processManeuverToken(ParseToken token) {
        this.anticipateNext(this::processDataSubStructureToken);
        try {
            return token.getName() != null && AttitudeManeuverKey.valueOf(token.getName()).process(token, this.context, this.currentManeuver);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processAttitudeDeterminationToken(ParseToken token) {
        this.anticipateNext(this.attitudeDeterminationSensorBlock != null ? this::processAttitudeDeterminationSensorToken : this::processDataSubStructureToken);
        if (token.getName() == null) {
            return false;
        }
        try {
            return AttitudeDeterminationKey.valueOf(token.getName()).process(token, this, this.context, this.attitudeDeterminationBlock);
        }
        catch (IllegalArgumentException iae1) {
            return false;
        }
    }

    private boolean processAttitudeDeterminationSensorToken(ParseToken token) {
        this.anticipateNext(this::processAttitudeDeterminationToken);
        if (token.getName() == null) {
            return false;
        }
        try {
            return AttitudeDeterminationSensorKey.valueOf(token.getName()).process(token, this.context, this.attitudeDeterminationSensorBlock);
        }
        catch (IllegalArgumentException iae1) {
            this.attitudeDeterminationBlock.addSensor(this.attitudeDeterminationSensorBlock);
            this.attitudeDeterminationSensorBlock = null;
            return false;
        }
    }

    private boolean processUserDefinedToken(ParseToken token) {
        this.anticipateNext(this::processDataSubStructureToken);
        if ("COMMENT".equals(token.getName())) {
            return token.getType() == TokenType.ENTRY ? this.userDefinedBlock.addComment(token.getContentAsNormalizedString()) : true;
        }
        if (token.getName().startsWith("USER_DEFINED_")) {
            if (token.getType() == TokenType.ENTRY) {
                this.userDefinedBlock.addEntry(token.getName().substring("USER_DEFINED_".length()), token.getContentAsNormalizedString());
            }
            return true;
        }
        return false;
    }
}

