/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.io.IOException;
import java.util.stream.Collectors;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.section.KvnStructureKey;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class AcmMetadataWriter
extends AbstractWriter {
    private final AcmMetadata metadata;
    private final TimeConverter timeConverter;

    AcmMetadataWriter(AcmMetadata metadata, TimeConverter timeConverter) {
        super(XmlStructureKey.metadata.name(), KvnStructureKey.META.name());
        this.metadata = metadata;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.metadata.getComments());
        generator.writeEntry(AdmMetadataKey.OBJECT_NAME.name(), this.metadata.getObjectName(), null, false);
        generator.writeEntry(AcmMetadataKey.INTERNATIONAL_DESIGNATOR.name(), this.metadata.getInternationalDesignator(), null, false);
        generator.writeEntry(AcmMetadataKey.CATALOG_NAME.name(), this.metadata.getCatalogName(), null, false);
        generator.writeEntry(AcmMetadataKey.OBJECT_DESIGNATOR.name(), this.metadata.getObjectDesignator(), null, false);
        generator.writeEntry(AcmMetadataKey.ORIGINATOR_POC.name(), this.metadata.getOriginatorPOC(), null, false);
        generator.writeEntry(AcmMetadataKey.ORIGINATOR_POSITION.name(), this.metadata.getOriginatorPosition(), null, false);
        generator.writeEntry(AcmMetadataKey.ORIGINATOR_PHONE.name(), this.metadata.getOriginatorPhone(), null, false);
        generator.writeEntry(AcmMetadataKey.ORIGINATOR_EMAIL.name(), this.metadata.getOriginatorEmail(), null, false);
        generator.writeEntry(AcmMetadataKey.ORIGINATOR_ADDRESS.name(), this.metadata.getOriginatorAddress(), null, false);
        generator.writeEntry(AcmMetadataKey.ODM_MSG_LINK.name(), this.metadata.getOdmMessageLink(), null, false);
        if (this.metadata.getCenter() != null) {
            generator.writeEntry(AdmMetadataKey.CENTER_NAME.name(), this.metadata.getCenter().getName(), null, false);
        }
        generator.writeEntry(MetadataKey.TIME_SYSTEM.name(), this.metadata.getTimeSystem(), false);
        generator.writeEntry(AcmMetadataKey.EPOCH_TZERO.name(), this.timeConverter, this.metadata.getEpochT0(), true, true);
        if (this.metadata.getAcmDataElements() != null) {
            generator.writeEntry(AcmMetadataKey.ACM_DATA_ELEMENTS.name(), this.metadata.getAcmDataElements().stream().map(e -> e.name()).collect(Collectors.toList()), false);
        }
        generator.writeEntry(AcmMetadataKey.START_TIME.name(), this.timeConverter, this.metadata.getStartTime(), false, false);
        generator.writeEntry(AcmMetadataKey.STOP_TIME.name(), this.timeConverter, this.metadata.getStopTime(), false, false);
        generator.writeEntry(AcmMetadataKey.TAIMUTC_AT_TZERO.name(), this.metadata.getTaimutcT0(), Unit.SECOND, false);
        if (this.metadata.getNextLeapEpoch() != null) {
            generator.writeEntry(AcmMetadataKey.NEXT_LEAP_EPOCH.name(), this.timeConverter, this.metadata.getNextLeapEpoch(), true, true);
            generator.writeEntry(AcmMetadataKey.NEXT_LEAP_TAIMUTC.name(), this.metadata.getNextLeapTaimutc(), Unit.SECOND, true);
        }
    }
}

