/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.List;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.adm.AdmMetadata;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.acm.AcmElements;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadataKey;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.time.AbsoluteDate;

public class AcmMetadata
extends AdmMetadata {
    private String catalogName;
    private String objectDesignator;
    private String originatorPOC;
    private String originatorPosition;
    private String originatorPhone;
    private String originatorEmail;
    private String originatorAddress;
    private String odmMessageLink;
    private AbsoluteDate epochT0;
    private List<AcmElements> acmDataElements;
    private AbsoluteDate startTime;
    private AbsoluteDate stopTime;
    private double taimutcT0 = Double.NaN;
    private AbsoluteDate nextLeapEpoch;
    private double nextLeapTaimutc = Double.NaN;

    public AcmMetadata(DataContext dataContext) {
    }

    @Override
    public void validate(double version) {
        this.checkNotNull(this.getObjectName(), AdmMetadataKey.OBJECT_NAME.name());
        this.checkNotNull((Object)this.getTimeSystem(), MetadataKey.TIME_SYSTEM.name());
        this.checkNotNull(this.epochT0, AcmMetadataKey.EPOCH_TZERO.name());
        if (this.nextLeapEpoch != null) {
            this.checkNotNaN(this.nextLeapTaimutc, AcmMetadataKey.NEXT_LEAP_TAIMUTC.name());
        }
    }

    public String getInternationalDesignator() {
        return this.getObjectID();
    }

    public void setInternationalDesignator(String internationalDesignator) {
        this.setObjectID(internationalDesignator);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.refuseFurtherComments();
        this.catalogName = catalogName;
    }

    public String getObjectDesignator() {
        return this.objectDesignator;
    }

    public void setObjectDesignator(String objectDesignator) {
        this.refuseFurtherComments();
        this.objectDesignator = objectDesignator;
    }

    public String getOriginatorPOC() {
        return this.originatorPOC;
    }

    public void setOriginatorPOC(String originatorPOC) {
        this.refuseFurtherComments();
        this.originatorPOC = originatorPOC;
    }

    public String getOriginatorPosition() {
        return this.originatorPosition;
    }

    public void setOriginatorPosition(String originatorPosition) {
        this.refuseFurtherComments();
        this.originatorPosition = originatorPosition;
    }

    public String getOriginatorPhone() {
        return this.originatorPhone;
    }

    public void setOriginatorPhone(String originatorPhone) {
        this.refuseFurtherComments();
        this.originatorPhone = originatorPhone;
    }

    public String getOriginatorEmail() {
        return this.originatorEmail;
    }

    public void setOriginatorEmail(String originatorEmail) {
        this.refuseFurtherComments();
        this.originatorEmail = originatorEmail;
    }

    public String getOriginatorAddress() {
        return this.originatorAddress;
    }

    public void setOriginatorAddress(String originatorAddress) {
        this.refuseFurtherComments();
        this.originatorAddress = originatorAddress;
    }

    public String getOdmMessageLink() {
        return this.odmMessageLink;
    }

    public void setOdmMessageLink(String odmMessageLink) {
        this.refuseFurtherComments();
        this.odmMessageLink = odmMessageLink;
    }

    public AbsoluteDate getEpochT0() {
        return this.epochT0;
    }

    public void setEpochT0(AbsoluteDate epochT0) {
        this.refuseFurtherComments();
        this.epochT0 = epochT0;
    }

    public List<AcmElements> getAcmDataElements() {
        return this.acmDataElements;
    }

    public void setAcmDataElements(List<AcmElements> acmDataElements) {
        this.refuseFurtherComments();
        this.acmDataElements = acmDataElements;
    }

    public AbsoluteDate getStartTime() {
        return this.startTime;
    }

    public void setStartTime(AbsoluteDate startTime) {
        this.refuseFurtherComments();
        this.startTime = startTime;
    }

    public AbsoluteDate getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(AbsoluteDate stopTime) {
        this.refuseFurtherComments();
        this.stopTime = stopTime;
    }

    public double getTaimutcT0() {
        return this.taimutcT0;
    }

    public void setTaimutcT0(double taimutcT0) {
        this.refuseFurtherComments();
        this.taimutcT0 = taimutcT0;
    }

    public AbsoluteDate getNextLeapEpoch() {
        return this.nextLeapEpoch;
    }

    public void setNextLeapEpoch(AbsoluteDate nextLeapEpoch) {
        this.refuseFurtherComments();
        this.nextLeapEpoch = nextLeapEpoch;
    }

    public double getNextLeapTaimutc() {
        return this.nextLeapTaimutc;
    }

    public void setNextLeapTaimutc(double nextLeapTaimutc) {
        this.refuseFurtherComments();
        this.nextLeapTaimutc = nextLeapTaimutc;
    }
}

