/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.List;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeCovarianceHistory;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDetermination;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuver;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudePhysicalProperties;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistory;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.section.Data;

public class AcmData
implements Data {
    private final List<AttitudeStateHistory> attitudeBlocks;
    private final AttitudePhysicalProperties physicBlock;
    private final List<AttitudeCovarianceHistory> covarianceBlocks;
    private final List<AttitudeManeuver> maneuverBlocks;
    private final AttitudeDetermination attitudeDeterminationBlock;
    private final UserDefined userDefinedBlock;

    public AcmData(List<AttitudeStateHistory> attitudeBlocks, AttitudePhysicalProperties physicBlock, List<AttitudeCovarianceHistory> covarianceBlocks, List<AttitudeManeuver> maneuverBlocks, AttitudeDetermination attitudeDeterminationBlock, UserDefined userDefinedBlock) {
        this.attitudeBlocks = attitudeBlocks;
        this.physicBlock = physicBlock;
        this.covarianceBlocks = covarianceBlocks;
        this.maneuverBlocks = maneuverBlocks;
        this.attitudeDeterminationBlock = attitudeDeterminationBlock;
        this.userDefinedBlock = userDefinedBlock;
    }

    @Override
    public void validate(double version) {
        if (this.attitudeBlocks != null) {
            for (AttitudeStateHistory ash : this.attitudeBlocks) {
                ash.getMetadata().validate(version);
            }
        }
        if (this.physicBlock != null) {
            this.physicBlock.validate(version);
        }
        if (this.covarianceBlocks != null) {
            for (AttitudeCovarianceHistory ch : this.covarianceBlocks) {
                ch.getMetadata().validate(version);
            }
        }
        if (this.maneuverBlocks != null) {
            for (AttitudeManeuver m : this.maneuverBlocks) {
                m.validate(version);
            }
        }
        if (this.attitudeDeterminationBlock != null) {
            this.attitudeDeterminationBlock.validate(version);
        }
        if (this.userDefinedBlock != null) {
            this.userDefinedBlock.validate(version);
        }
    }

    public List<AttitudeStateHistory> getAttitudeBlocks() {
        return this.attitudeBlocks;
    }

    public AttitudePhysicalProperties getPhysicBlock() {
        return this.physicBlock;
    }

    public List<AttitudeCovarianceHistory> getCovarianceBlocks() {
        return this.covarianceBlocks;
    }

    public List<AttitudeManeuver> getManeuverBlocks() {
        return this.maneuverBlocks;
    }

    public AttitudeDetermination getAttitudeDeterminationBlock() {
        return this.attitudeDeterminationBlock;
    }

    public UserDefined getUserDefinedBlock() {
        return this.userDefinedBlock;
    }
}

