/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.adm.AdmHeader;
import org.orekit.files.ccsds.ndm.adm.acm.AcmData;
import org.orekit.files.ccsds.ndm.adm.acm.AcmMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AcmSatelliteEphemeris;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistory;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class Acm
extends NdmConstituent<AdmHeader, Segment<AcmMetadata, AcmData>>
implements AttitudeEphemerisFile<TimeStampedAngularCoordinates, AttitudeStateHistory> {
    public static final String ROOT = "acm";
    public static final String FORMAT_VERSION_KEY = "CCSDS_ACM_VERS";
    public static final String ATT_LINE = "attLine";
    public static final String COV_LINE = "covLine";
    public static final String UNKNOWN_OBJECT = "UNKNOWN";

    public Acm(AdmHeader header, List<Segment<AcmMetadata, AcmData>> segments, IERSConventions conventions, DataContext dataContext) {
        super(header, segments, conventions, dataContext);
    }

    public AcmMetadata getMetadata() {
        return (AcmMetadata)((Segment)this.getSegments().get(0)).getMetadata();
    }

    public AcmData getData() {
        return (AcmData)((Segment)this.getSegments().get(0)).getData();
    }

    @Override
    public Map<String, AcmSatelliteEphemeris> getSatellites() {
        String name = this.getMetadata().getObjectName() != null ? this.getMetadata().getObjectName() : (this.getMetadata().getInternationalDesignator() != null ? this.getMetadata().getInternationalDesignator() : (this.getMetadata().getObjectDesignator() != null ? this.getMetadata().getObjectDesignator() : UNKNOWN_OBJECT));
        List<AttitudeStateHistory> histories = ((AcmData)((Segment)this.getSegments().get(0)).getData()).getAttitudeBlocks();
        return histories == null ? Collections.emptyMap() : Collections.singletonMap(name, new AcmSatelliteEphemeris(name, histories));
    }
}

