/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm;

import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.utils.TimeStampedAngularCoordinates;

class SpinFinder {
    private final Vector3D spin;
    private final double spinAlpha;
    private final double spinDelta;
    private final double spinAngle;

    SpinFinder(TimeStampedAngularCoordinates attitude) {
        this.spin = attitude.getRotation().applyInverseTo(Vector3D.PLUS_K);
        this.spinAlpha = this.spin.getAlpha();
        this.spinDelta = this.spin.getDelta();
        Rotation alignSpin = new Rotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, 1.5707963267948966 + this.spinAlpha, 1.5707963267948966 - this.spinDelta, 0.0);
        Rotation phasing = attitude.getRotation().applyTo(alignSpin.revert());
        this.spinAngle = FastMath.copySign((double)phasing.getAngle(), (double)phasing.getAxis(RotationConvention.FRAME_TRANSFORM).getZ());
    }

    public Vector3D getSpin() {
        return this.spin;
    }

    public double getSpinDelta() {
        return this.spinDelta;
    }

    public double getSpinAlpha() {
        return this.spinAlpha;
    }

    public double getSpinAngle() {
        return this.spinAngle;
    }
}

