/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.utils.units.Unit;
import org.orekit.utils.units.UnitsCache;

public class RotationXmlTokenBuilder
implements XmlTokenBuilder {
    private static final String ANGLE = "angle";
    private static final String RATE = "rate";
    private static final String UNITS = "units";
    private final UnitsCache cache = new UnitsCache();

    @Override
    public List<ParseToken> buildTokens(boolean startTag, boolean isLeaf, String qName, String content, Map<String, String> attributes, int lineNumber, String fileName) {
        String name = attributes.get(ANGLE);
        if (name == null) {
            name = attributes.get(RATE);
        }
        if (startTag) {
            return Collections.singletonList(new ParseToken(TokenType.START, name, content, Unit.NONE, lineNumber, fileName));
        }
        ArrayList<ParseToken> built = new ArrayList<ParseToken>(2);
        if (isLeaf) {
            Unit units = this.cache.getUnits(attributes.get(UNITS));
            built.add(new ParseToken(TokenType.ENTRY, name, content, units, lineNumber, fileName));
        }
        built.add(new ParseToken(TokenType.STOP, name, null, Unit.NONE, lineNumber, fileName));
        return built;
    }
}

