/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

class PrecessionFinder {
    private final Vector3D axis;
    private final double precessionAngle;
    private final double angularVelocity;

    PrecessionFinder(FieldVector3D<UnivariateDerivative2> spin) {
        UnivariateDerivative2 nS = (UnivariateDerivative2)spin.getNorm();
        if (nS.getValue() == 0.0) {
            this.axis = Vector3D.PLUS_K;
            this.precessionAngle = 0.0;
            this.angularVelocity = 0.0;
        } else {
            FieldVector3D s = spin.scalarMultiply((CalculusFieldElement)nS.reciprocal());
            Vector3D s0 = new Vector3D(((UnivariateDerivative2)s.getX()).getValue(), ((UnivariateDerivative2)s.getY()).getValue(), ((UnivariateDerivative2)s.getZ()).getValue());
            Vector3D s1 = new Vector3D(((UnivariateDerivative2)s.getX()).getFirstDerivative(), ((UnivariateDerivative2)s.getY()).getFirstDerivative(), ((UnivariateDerivative2)s.getZ()).getFirstDerivative());
            Vector3D s2 = new Vector3D(((UnivariateDerivative2)s.getX()).getSecondDerivative(), ((UnivariateDerivative2)s.getY()).getSecondDerivative(), ((UnivariateDerivative2)s.getZ()).getSecondDerivative());
            double nV2 = s1.getNormSq();
            if (nV2 == 0.0) {
                this.axis = s0;
                this.precessionAngle = 0.0;
                this.angularVelocity = 0.0;
            } else {
                if (new Vector3D(((UnivariateDerivative2)spin.getX()).getSecondDerivative(), ((UnivariateDerivative2)spin.getY()).getSecondDerivative(), ((UnivariateDerivative2)spin.getZ()).getSecondDerivative()).getNormSq() == 0.0) {
                    throw new OrekitException((Localizable)OrekitMessages.CANNOT_ESTIMATE_PRECESSION_WITHOUT_PROPER_DERIVATIVES, new Object[0]);
                }
                double nV = FastMath.sqrt((double)nV2);
                Vector3D v = s1.scalarMultiply(1.0 / nV);
                Vector3D w = Vector3D.crossProduct((Vector3D)s0, (Vector3D)v);
                this.precessionAngle = FastMath.atan2((double)nV2, (double)Vector3D.dotProduct((Vector3D)s2, (Vector3D)w));
                SinCos sc = FastMath.sinCos((double)this.precessionAngle);
                this.angularVelocity = nV / sc.sin();
                this.axis = new Vector3D(sc.cos(), s0, sc.sin(), w);
            }
        }
    }

    public Vector3D getAxis() {
        return this.axis;
    }

    public double getPrecessionAngle() {
        return this.precessionAngle;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }
}

