/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative1;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.PrecessionFinder;
import org.orekit.files.ccsds.ndm.adm.SpinFinder;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.units.Unit;

public enum AttitudeType {
    QUATERNION((Iterable)Collections.singleton(new VersionedName(1.0, "QUATERNION")), AngularDerivativesFilter.USE_R, new Unit[]{Unit.ONE, Unit.ONE, Unit.ONE, Unit.ONE}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            int[] nArray;
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            Rotation rotation = coordinates.getRotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            double[] data = new double[4];
            data[quaternionIndex[0]] = rotation.getQ0();
            data[quaternionIndex[1]] = rotation.getQ1();
            data[quaternionIndex[2]] = rotation.getQ2();
            data[quaternionIndex[3]] = rotation.getQ3();
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation;
            Rotation rotation2 = rotation = isFirst ? new Rotation(components[0], components[1], components[2], components[3], true) : new Rotation(components[3], components[0], components[1], components[2], true);
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return new TimeStampedAngularCoordinates(date, rotation, Vector3D.ZERO, Vector3D.ZERO);
        }
    }
    ,
    QUATERNION_DERIVATIVE((Iterable)Collections.singleton(new VersionedName(1.0, "QUATERNION/DERIVATIVE")), AngularDerivativesFilter.USE_RR, new Unit[]{Unit.ONE, Unit.ONE, Unit.ONE, Unit.ONE, Units.ONE_PER_S, Units.ONE_PER_S, Units.ONE_PER_S, Units.ONE_PER_S}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            int[] nArray;
            FieldRotation rotation = coordinates.toUnivariateDerivative1Rotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            if (isFirst) {
                int[] nArray2 = new int[8];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 4;
                nArray2[5] = 5;
                nArray2[6] = 6;
                nArray = nArray2;
                nArray2[7] = 7;
            } else {
                int[] nArray3 = new int[8];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray3[3] = 2;
                nArray3[4] = 7;
                nArray3[5] = 4;
                nArray3[6] = 5;
                nArray = nArray3;
                nArray3[7] = 6;
            }
            int[] quaternionIndex = nArray;
            double[] data = new double[8];
            data[quaternionIndex[0]] = ((UnivariateDerivative1)rotation.getQ0()).getValue();
            data[quaternionIndex[1]] = ((UnivariateDerivative1)rotation.getQ1()).getValue();
            data[quaternionIndex[2]] = ((UnivariateDerivative1)rotation.getQ2()).getValue();
            data[quaternionIndex[3]] = ((UnivariateDerivative1)rotation.getQ3()).getValue();
            data[quaternionIndex[4]] = ((UnivariateDerivative1)rotation.getQ0()).getFirstDerivative();
            data[quaternionIndex[5]] = ((UnivariateDerivative1)rotation.getQ1()).getFirstDerivative();
            data[quaternionIndex[6]] = ((UnivariateDerivative1)rotation.getQ2()).getFirstDerivative();
            data[quaternionIndex[7]] = ((UnivariateDerivative1)rotation.getQ3()).getFirstDerivative();
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            FieldRotation rotation;
            FieldRotation fieldRotation = rotation = isFirst ? new FieldRotation((CalculusFieldElement)new UnivariateDerivative1(components[0], components[4]), (CalculusFieldElement)new UnivariateDerivative1(components[1], components[5]), (CalculusFieldElement)new UnivariateDerivative1(components[2], components[6]), (CalculusFieldElement)new UnivariateDerivative1(components[3], components[7]), true) : new FieldRotation((CalculusFieldElement)new UnivariateDerivative1(components[3], components[7]), (CalculusFieldElement)new UnivariateDerivative1(components[0], components[4]), (CalculusFieldElement)new UnivariateDerivative1(components[1], components[5]), (CalculusFieldElement)new UnivariateDerivative1(components[2], components[6]), true);
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return new TimeStampedAngularCoordinates(date, rotation);
        }
    }
    ,
    QUATERNION_EULER_RATES((Iterable)Collections.singleton(new VersionedName(1.0, "QUATERNION/RATE")), AngularDerivativesFilter.USE_RR, new Unit[]{Unit.ONE, Unit.ONE, Unit.ONE, Unit.ONE, Units.DEG_PER_S, Units.DEG_PER_S, Units.DEG_PER_S}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            int[] nArray;
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            FieldRotation rotation = coordinates.toUnivariateDerivative1Rotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            UnivariateDerivative1[] euler = (UnivariateDerivative1[])rotation.getAngles(eulerRotSequence, RotationConvention.FRAME_TRANSFORM);
            double[] data = new double[7];
            data[quaternionIndex[0]] = ((UnivariateDerivative1)rotation.getQ0()).getValue();
            data[quaternionIndex[1]] = ((UnivariateDerivative1)rotation.getQ1()).getValue();
            data[quaternionIndex[2]] = ((UnivariateDerivative1)rotation.getQ2()).getValue();
            data[quaternionIndex[3]] = ((UnivariateDerivative1)rotation.getQ3()).getValue();
            data[4] = euler[0].getFirstDerivative();
            data[5] = euler[1].getFirstDerivative();
            data[6] = euler[2].getFirstDerivative();
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = isFirst ? new Rotation(components[0], components[1], components[2], components[3], true) : new Rotation(components[3], components[0], components[1], components[2], true);
            double[] euler = rotation.getAngles(eulerRotSequence, RotationConvention.FRAME_TRANSFORM);
            FieldRotation rUD1 = new FieldRotation(eulerRotSequence, RotationConvention.FRAME_TRANSFORM, (CalculusFieldElement)new UnivariateDerivative1(euler[0], components[4]), (CalculusFieldElement)new UnivariateDerivative1(euler[1], components[5]), (CalculusFieldElement)new UnivariateDerivative1(euler[2], components[6]));
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, rUD1);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    }
    ,
    QUATERNION_ANGVEL((Iterable)Collections.singleton(new VersionedName(2.0, "QUATERNION/ANGVEL")), AngularDerivativesFilter.USE_RR, new Unit[]{Unit.ONE, Unit.ONE, Unit.ONE, Unit.ONE, Units.DEG_PER_S, Units.DEG_PER_S, Units.DEG_PER_S}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            int[] nArray;
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            TimeStampedAngularCoordinates c = isExternal2SpacecraftBody ? coordinates : coordinates.revert();
            Vector3D rotationRate = 4.QUATERNION_ANGVEL.metadataRate(isSpacecraftBodyRate, c.getRotationRate(), c.getRotation());
            double[] data = new double[7];
            data[quaternionIndex[0]] = c.getRotation().getQ0();
            data[quaternionIndex[1]] = c.getRotation().getQ1();
            data[quaternionIndex[2]] = c.getRotation().getQ2();
            data[quaternionIndex[3]] = c.getRotation().getQ3();
            data[4] = rotationRate.getX();
            data[5] = rotationRate.getY();
            data[6] = rotationRate.getZ();
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = isFirst ? new Rotation(components[0], components[1], components[2], components[3], true) : new Rotation(components[3], components[0], components[1], components[2], true);
            Vector3D rotationRate = 4.QUATERNION_ANGVEL.orekitRate(isSpacecraftBodyRate, new Vector3D(components[4], components[5], components[6]), rotation);
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    }
    ,
    EULER_ANGLE((Iterable)Collections.singleton(new VersionedName(1.0, "EULER_ANGLE")), AngularDerivativesFilter.USE_R, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            Rotation rotation = coordinates.getRotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return rotation.getAngles(eulerRotSequence, RotationConvention.FRAME_TRANSFORM);
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = new Rotation(eulerRotSequence, RotationConvention.FRAME_TRANSFORM, components[0], components[1], components[2]);
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return new TimeStampedAngularCoordinates(date, rotation, Vector3D.ZERO, Vector3D.ZERO);
        }
    }
    ,
    EULER_ANGLE_DERIVATIVE((Iterable)Arrays.asList(new VersionedName(1.0, "EULER_ANGLE/RATE"), new VersionedName(2.0, "EULER_ANGLE/DERIVATIVE")), AngularDerivativesFilter.USE_RR, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S, Units.DEG_PER_S, Units.DEG_PER_S}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            FieldRotation rotation = coordinates.toUnivariateDerivative1Rotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            UnivariateDerivative1[] angles = (UnivariateDerivative1[])rotation.getAngles(eulerRotSequence, RotationConvention.FRAME_TRANSFORM);
            return new double[]{angles[0].getValue(), angles[1].getValue(), angles[2].getValue(), angles[0].getFirstDerivative(), angles[1].getFirstDerivative(), angles[2].getFirstDerivative()};
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            FieldRotation rotation = new FieldRotation(eulerRotSequence, RotationConvention.FRAME_TRANSFORM, (CalculusFieldElement)new UnivariateDerivative1(components[0], components[3]), (CalculusFieldElement)new UnivariateDerivative1(components[1], components[4]), (CalculusFieldElement)new UnivariateDerivative1(components[2], components[5]));
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return new TimeStampedAngularCoordinates(date, rotation);
        }
    }
    ,
    EULER_ANGLE_ANGVEL((Iterable)Collections.singleton(new VersionedName(2.0, "EULER_ANGLE/ANGVEL")), AngularDerivativesFilter.USE_RR, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S, Units.DEG_PER_S, Units.DEG_PER_S}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            TimeStampedAngularCoordinates c = isExternal2SpacecraftBody ? coordinates : coordinates.revert();
            Vector3D rotationRate = 7.EULER_ANGLE_ANGVEL.metadataRate(isSpacecraftBodyRate, c.getRotationRate(), c.getRotation());
            double[] angles = c.getRotation().getAngles(eulerRotSequence, RotationConvention.FRAME_TRANSFORM);
            return new double[]{angles[0], angles[1], angles[2], rotationRate.getX(), rotationRate.getY(), rotationRate.getZ()};
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = new Rotation(eulerRotSequence, RotationConvention.FRAME_TRANSFORM, components[0], components[1], components[2]);
            Vector3D rotationRate = 7.EULER_ANGLE_ANGVEL.orekitRate(isSpacecraftBodyRate, new Vector3D(components[3], components[4], components[5]), rotation);
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    }
    ,
    SPIN((Iterable)Collections.singleton(new VersionedName(1.0, "SPIN")), AngularDerivativesFilter.USE_R, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            TimeStampedAngularCoordinates c = isExternal2SpacecraftBody ? coordinates : coordinates.revert();
            SpinFinder sf = new SpinFinder(c);
            double spinAngleVel = coordinates.getRotationRate().getZ();
            return new double[]{sf.getSpinAlpha(), sf.getSpinDelta(), sf.getSpinAngle(), spinAngleVel};
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = new Rotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, 1.5707963267948966 + components[0], 1.5707963267948966 - components[1], components[2]);
            Vector3D rotationRate = new Vector3D(0.0, 0.0, components[3]);
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    }
    ,
    SPIN_NUTATION((Iterable)Collections.singleton(new VersionedName(1.0, "SPIN/NUTATION")), AngularDerivativesFilter.USE_RR, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S, Unit.DEGREE, Unit.SECOND, Unit.DEGREE}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            TimeStampedAngularCoordinates c = isExternal2SpacecraftBody ? coordinates : coordinates.revert();
            SpinFinder sf = new SpinFinder(c);
            FieldRotation<UnivariateDerivative2> c2 = c.toUnivariateDerivative2Rotation();
            FieldVector3D spinAxis = c2.applyInverseTo(Vector3D.PLUS_K);
            PrecessionFinder pf = new PrecessionFinder((FieldVector3D<UnivariateDerivative2>)spinAxis);
            Rotation intermediate2Inert = new Rotation(Vector3D.PLUS_K, pf.getAxis());
            FieldRotation intermediate2Body = c2.applyTo(intermediate2Inert);
            UnivariateDerivative2[] euler = (UnivariateDerivative2[])intermediate2Body.getAngles(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM);
            return new double[]{sf.getSpinAlpha(), sf.getSpinDelta(), sf.getSpinAngle(), euler[2].getFirstDerivative(), pf.getPrecessionAngle(), Math.PI * 2 / pf.getAngularVelocity(), euler[2].getValue() - 1.5707963267948966};
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation inert2Body0 = new Rotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, 1.5707963267948966 + components[0], 1.5707963267948966 - components[1], components[2]);
            SinCos scNutation = FastMath.sinCos((double)components[4]);
            SinCos scPhase = FastMath.sinCos((double)components[6]);
            Vector3D momentumBody = new Vector3D(scNutation.sin() * scPhase.cos(), -scNutation.sin() * scPhase.sin(), scNutation.cos());
            Vector3D momentumInert = inert2Body0.applyInverseTo(momentumBody);
            Rotation inert2Intermediate = new Rotation(momentumInert, Vector3D.PLUS_K);
            Rotation intermediate2Body0 = inert2Body0.applyTo(inert2Intermediate.revert());
            double[] euler0 = intermediate2Body0.getAngles(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM);
            FieldRotation intermediate2Body = new FieldRotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, (CalculusFieldElement)new UnivariateDerivative2(euler0[0], Math.PI * 2 / components[5], 0.0), (CalculusFieldElement)new UnivariateDerivative2(euler0[1], 0.0, 0.0), (CalculusFieldElement)new UnivariateDerivative2(euler0[2], components[3], 0.0));
            FieldRotation inert2Body = intermediate2Body.applyTo(inert2Intermediate);
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, inert2Body);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    }
    ,
    SPIN_NUTATION_MOMENTUM((Iterable)Collections.singleton(new VersionedName(2.0, "SPIN/NUTATION_MOM")), AngularDerivativesFilter.USE_RR, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S}){

        @Override
        public double[] generateData(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            TimeStampedAngularCoordinates c = isExternal2SpacecraftBody ? coordinates : coordinates.revert();
            SpinFinder sf = new SpinFinder(c);
            FieldRotation<UnivariateDerivative2> c2 = c.toUnivariateDerivative2Rotation();
            FieldVector3D spinAxis = c2.applyInverseTo(Vector3D.PLUS_K);
            PrecessionFinder pf = new PrecessionFinder((FieldVector3D<UnivariateDerivative2>)spinAxis);
            Rotation intermediate2Inert = new Rotation(Vector3D.PLUS_K, pf.getAxis());
            FieldRotation intermediate2Body = c2.applyTo(intermediate2Inert);
            double spinAngleVel = ((UnivariateDerivative2[])intermediate2Body.getAngles(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM))[2].getFirstDerivative();
            return new double[]{sf.getSpinAlpha(), sf.getSpinDelta(), sf.getSpinAngle(), spinAngleVel, pf.getAxis().getAlpha(), pf.getAxis().getDelta(), pf.getAngularVelocity()};
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            SinCos scAlpha = FastMath.sinCos((double)components[4]);
            SinCos scDelta = FastMath.sinCos((double)components[5]);
            Vector3D momentumInert = new Vector3D(scAlpha.cos() * scDelta.cos(), scAlpha.sin() * scDelta.cos(), scDelta.sin());
            Rotation inert2Intermediate = new Rotation(momentumInert, Vector3D.PLUS_K);
            Rotation inert2Body0 = new Rotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, 1.5707963267948966 + components[0], 1.5707963267948966 - components[1], components[2]);
            Rotation intermediate2Body0 = inert2Body0.applyTo(inert2Intermediate.revert());
            double[] euler0 = intermediate2Body0.getAngles(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM);
            FieldRotation intermediate2Body = new FieldRotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, (CalculusFieldElement)new UnivariateDerivative2(euler0[0], components[6], 0.0), (CalculusFieldElement)new UnivariateDerivative2(euler0[1], 0.0, 0.0), (CalculusFieldElement)new UnivariateDerivative2(euler0[2], components[3], 0.0));
            FieldRotation inert2Body = intermediate2Body.applyTo(inert2Intermediate);
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, inert2Body);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    };

    private static final Map<String, AttitudeType> MAP;
    private final Iterable<VersionedName> ccsdsNames;
    private final AngularDerivativesFilter filter;
    private final Unit[] units;

    private AttitudeType(Iterable<VersionedName> ccsdsNames, AngularDerivativesFilter filter, Unit ... units) {
        this.ccsdsNames = ccsdsNames;
        this.filter = filter;
        this.units = (Unit[])units.clone();
    }

    public String getName(double formatVersion) {
        String name = null;
        for (VersionedName vn : this.ccsdsNames) {
            if (name != null && !(formatVersion >= vn.since)) continue;
            name = vn.name;
        }
        return name;
    }

    public String toString() {
        return this.getName(Double.POSITIVE_INFINITY);
    }

    public static AttitudeType parseType(String typeSpecification) {
        AttitudeType type = MAP.get(typeSpecification);
        if (type == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_ATTITUDE_TYPE, typeSpecification);
        }
        return type;
    }

    public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates attitude) {
        double[] data = this.generateData(isFirst, isExternal2SpacecraftBody, eulerRotSequence, isSpacecraftBodyRate, attitude);
        String[] fields = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            fields[i] = AccurateFormatter.format(this.units[i].fromSI(data[i]));
        }
        return fields;
    }

    public abstract double[] generateData(boolean var1, boolean var2, RotationOrder var3, boolean var4, TimeStampedAngularCoordinates var5);

    public TimeStampedAngularCoordinates parse(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, ContextBinding context, String[] fields) {
        AbsoluteDate date = context.getTimeSystem().getConverter(context).parse(fields[0]);
        double[] components = new double[fields.length - 1];
        for (int i = 0; i < components.length; ++i) {
            components[i] = this.units[i].toSI(Double.parseDouble(fields[i + 1]));
        }
        return this.build(isFirst, isExternal2SpacecraftBody, eulerRotSequence, isSpacecraftBodyRate, date, components);
    }

    public abstract TimeStampedAngularCoordinates build(boolean var1, boolean var2, RotationOrder var3, boolean var4, AbsoluteDate var5, double ... var6);

    public AngularDerivativesFilter getAngularDerivativesFilter() {
        return this.filter;
    }

    private Vector3D metadataRate(boolean isSpacecraftBodyRate, Vector3D rate, Rotation rotation) {
        return isSpacecraftBodyRate ? rate : rotation.applyInverseTo(rate);
    }

    private Vector3D orekitRate(boolean isSpacecraftBodyRate, Vector3D rate, Rotation rotation) {
        return isSpacecraftBodyRate ? rate : rotation.applyTo(rate);
    }

    static {
        MAP = new HashMap<String, AttitudeType>();
        for (AttitudeType type : AttitudeType.values()) {
            for (VersionedName vn : type.ccsdsNames) {
                MAP.put(vn.name, type);
            }
        }
    }

    private static class VersionedName {
        private final double since;
        private final String name;

        VersionedName(double since, String name) {
            this.since = since;
            this.name = name;
        }
    }
}

