/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.AbstractBuilder;
import org.orekit.files.ccsds.ndm.NdmWriter;
import org.orekit.files.ccsds.ndm.adm.acm.AcmWriter;
import org.orekit.files.ccsds.ndm.adm.aem.AemWriter;
import org.orekit.files.ccsds.ndm.adm.apm.ApmWriter;
import org.orekit.files.ccsds.ndm.cdm.CdmWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmWriter;
import org.orekit.files.ccsds.ndm.odm.oem.OemWriter;
import org.orekit.files.ccsds.ndm.odm.omm.OmmWriter;
import org.orekit.files.ccsds.ndm.odm.opm.OpmWriter;
import org.orekit.files.ccsds.ndm.tdm.IdentityConverter;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.TdmWriter;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class WriterBuilder
extends AbstractBuilder<WriterBuilder> {
    @DefaultDataContext
    public WriterBuilder() {
        this(DataContext.getDefault());
    }

    public WriterBuilder(DataContext dataContext) {
        this(IERSConventions.IERS_2010, Double.NaN, Double.NaN, dataContext, null, new IdentityConverter());
    }

    private WriterBuilder(IERSConventions conventions, double equatorialRadius, double flattening, DataContext dataContext, AbsoluteDate missionReferenceDate, RangeUnitsConverter rangeUnitsConverter) {
        super(conventions, equatorialRadius, flattening, dataContext, missionReferenceDate, rangeUnitsConverter);
    }

    @Override
    protected WriterBuilder create(IERSConventions newConventions, double newEquatorialRadius, double newFlattening, DataContext newDataContext, AbsoluteDate newMissionReferenceDate, RangeUnitsConverter newRangeUnitsConverter) {
        return new WriterBuilder(newConventions, newEquatorialRadius, newFlattening, newDataContext, newMissionReferenceDate, newRangeUnitsConverter);
    }

    public NdmWriter buildNdmWriter() {
        return new NdmWriter(this);
    }

    public OpmWriter buildOpmWriter() {
        return new OpmWriter(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate());
    }

    public OmmWriter buildOmmWriter() {
        return new OmmWriter(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate());
    }

    public OemWriter buildOemWriter() {
        return new OemWriter(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate());
    }

    public OcmWriter buildOcmWriter() {
        return new OcmWriter(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext());
    }

    public ApmWriter buildApmWriter() {
        return new ApmWriter(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate());
    }

    public AemWriter buildAemWriter() {
        return new AemWriter(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate());
    }

    public AcmWriter buildAcmWriter() {
        return new AcmWriter(this.getConventions(), this.getDataContext());
    }

    public TdmWriter buildTdmWriter() {
        return new TdmWriter(this.getConventions(), this.getDataContext(), this.getRangeUnitsConverter());
    }

    public CdmWriter buildCdmWriter() {
        return new CdmWriter(this.getConventions(), this.getDataContext());
    }
}

