/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Function;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.AbstractBuilder;
import org.orekit.files.ccsds.ndm.NdmParser;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.acm.AcmParser;
import org.orekit.files.ccsds.ndm.adm.aem.AemParser;
import org.orekit.files.ccsds.ndm.adm.apm.ApmParser;
import org.orekit.files.ccsds.ndm.cdm.CdmParser;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmParser;
import org.orekit.files.ccsds.ndm.odm.oem.OemParser;
import org.orekit.files.ccsds.ndm.odm.omm.OmmParser;
import org.orekit.files.ccsds.ndm.odm.opm.OpmParser;
import org.orekit.files.ccsds.ndm.tdm.IdentityConverter;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.TdmParser;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class ParserBuilder
extends AbstractBuilder<ParserBuilder> {
    private final boolean simpleEOP;
    private final double mu;
    private final double defaultMass;
    private final int defaultInterpolationDegree;
    private final ParsedUnitsBehavior parsedUnitsBehavior;
    private final Function<ParseToken, List<ParseToken>>[] filters;

    @DefaultDataContext
    public ParserBuilder() {
        this(DataContext.getDefault());
    }

    public ParserBuilder(DataContext dataContext) {
        this(IERSConventions.IERS_2010, Double.NaN, Double.NaN, dataContext, null, new IdentityConverter(), true, Double.NaN, Double.NaN, 1, ParsedUnitsBehavior.CONVERT_COMPATIBLE, (Function[])Array.newInstance(Function.class, 0));
    }

    private ParserBuilder(IERSConventions conventions, double equatorialRadius, double flattening, DataContext dataContext, AbsoluteDate missionReferenceDate, RangeUnitsConverter rangeUnitsConverter, boolean simpleEOP, double mu, double defaultMass, int defaultInterpolationDegree, ParsedUnitsBehavior parsedUnitsBehavior, Function<ParseToken, List<ParseToken>>[] filters) {
        super(conventions, equatorialRadius, flattening, dataContext, missionReferenceDate, rangeUnitsConverter);
        this.simpleEOP = simpleEOP;
        this.mu = mu;
        this.defaultMass = defaultMass;
        this.defaultInterpolationDegree = defaultInterpolationDegree;
        this.parsedUnitsBehavior = parsedUnitsBehavior;
        this.filters = (Function[])filters.clone();
    }

    @Override
    protected ParserBuilder create(IERSConventions newConventions, double newEquatorialRadius, double newFlattening, DataContext newDataContext, AbsoluteDate newMissionReferenceDate, RangeUnitsConverter newRangeUnitsConverter) {
        return new ParserBuilder(newConventions, newEquatorialRadius, newFlattening, newDataContext, newMissionReferenceDate, newRangeUnitsConverter, this.simpleEOP, this.mu, this.defaultMass, this.defaultInterpolationDegree, this.parsedUnitsBehavior, this.filters);
    }

    public ParserBuilder withSimpleEOP(boolean newSimpleEOP) {
        return new ParserBuilder(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), newSimpleEOP, this.getMu(), this.getDefaultMass(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public boolean isSimpleEOP() {
        return this.simpleEOP;
    }

    public ParserBuilder withMu(double newMu) {
        return new ParserBuilder(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), newMu, this.getDefaultMass(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public double getMu() {
        return this.mu;
    }

    public ParserBuilder withDefaultMass(double newDefaultMass) {
        return new ParserBuilder(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), this.getMu(), newDefaultMass, this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public double getDefaultMass() {
        return this.defaultMass;
    }

    public ParserBuilder withDefaultInterpolationDegree(int newDefaultInterpolationDegree) {
        return new ParserBuilder(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), this.getMu(), this.getDefaultMass(), newDefaultInterpolationDegree, this.getParsedUnitsBehavior(), this.getFilters());
    }

    public int getDefaultInterpolationDegree() {
        return this.defaultInterpolationDegree;
    }

    public ParserBuilder withParsedUnitsBehavior(ParsedUnitsBehavior newParsedUnitsBehavior) {
        return new ParserBuilder(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), this.getMu(), this.getDefaultMass(), this.getDefaultInterpolationDegree(), newParsedUnitsBehavior, this.getFilters());
    }

    public ParsedUnitsBehavior getParsedUnitsBehavior() {
        return this.parsedUnitsBehavior;
    }

    public ParserBuilder withFilter(Function<ParseToken, List<ParseToken>> filter) {
        Function[] newFilters = (Function[])Array.newInstance(Function.class, this.filters.length + 1);
        System.arraycopy(this.filters, 0, newFilters, 0, this.filters.length);
        newFilters[this.filters.length] = filter;
        return new ParserBuilder(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), this.getMu(), this.getDefaultMass(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior(), newFilters);
    }

    public Function<ParseToken, List<ParseToken>>[] getFilters() {
        return (Function[])this.filters.clone();
    }

    public NdmParser buildNdmParser() {
        return new NdmParser(this, this.getFilters());
    }

    public OpmParser buildOpmParser() {
        return new OpmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getMu(), this.getDefaultMass(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public OmmParser buildOmmParser() {
        return new OmmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getMu(), this.getDefaultMass(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public OemParser buildOemParser() {
        return new OemParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getMu(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public OcmParser buildOcmParser() {
        return new OcmParser(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.isSimpleEOP(), this.getDataContext(), this.getMu(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public ApmParser buildApmParser() {
        return new ApmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public AemParser buildAemParser() {
        return new AemParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public AcmParser buildAcmParser() {
        return new AcmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getParsedUnitsBehavior(), this.getFilters());
    }

    public TdmParser buildTdmParser() {
        return new TdmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getParsedUnitsBehavior(), this.getRangeUnitsConverter(), this.getFilters());
    }

    public CdmParser buildCdmParser() {
        return new CdmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getParsedUnitsBehavior(), this.getFilters());
    }
}

