/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import java.io.IOException;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.Ndm;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.NdmStructureKey;
import org.orekit.files.ccsds.ndm.WriterBuilder;
import org.orekit.files.ccsds.ndm.adm.acm.Acm;
import org.orekit.files.ccsds.ndm.adm.aem.Aem;
import org.orekit.files.ccsds.ndm.adm.apm.Apm;
import org.orekit.files.ccsds.ndm.odm.ocm.Ocm;
import org.orekit.files.ccsds.ndm.odm.oem.Oem;
import org.orekit.files.ccsds.ndm.odm.omm.Omm;
import org.orekit.files.ccsds.ndm.odm.opm.Opm;
import org.orekit.files.ccsds.ndm.tdm.Tdm;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.files.ccsds.utils.generation.MessageWriter;

public class NdmWriter {
    private final WriterBuilder builder;
    private boolean started;
    private int count;

    public NdmWriter(WriterBuilder builder) {
        this.builder = builder;
        this.started = false;
        this.count = 0;
    }

    public void writeMessage(Generator generator, Ndm message) throws IOException {
        for (String string : message.getComments()) {
            this.writeComment(generator, string);
        }
        for (NdmConstituent ndmConstituent : message.getConstituents()) {
            this.writeConstituent(generator, ndmConstituent);
        }
    }

    private void startMessageIfNeeded(Generator generator) throws IOException {
        if (!this.started) {
            generator.enterSection(NdmStructureKey.ndm.name());
            this.started = true;
        }
    }

    public void writeComment(Generator generator, String comment) throws IOException {
        this.startMessageIfNeeded(generator);
        if (this.count > 0) {
            throw new OrekitException((Localizable)OrekitMessages.ATTEMPT_TO_GENERATE_MALFORMED_FILE, generator.getOutputName());
        }
        generator.writeEntry(NdmStructureKey.COMMENT.name(), comment, null, false);
    }

    public <H extends Header, S extends Segment<?, ?>, F extends NdmConstituent<H, S>> void writeConstituent(Generator generator, F constituent) throws IOException {
        this.startMessageIfNeeded(generator);
        MessageWriter<H, S, F> writer = this.buildWriter(constituent);
        writer.writeMessage(generator, constituent);
        ++this.count;
    }

    private <H extends Header, S extends Segment<?, ?>, F extends NdmConstituent<H, S>> MessageWriter<H, S, F> buildWriter(F constituent) throws IOException {
        if (constituent instanceof Tdm) {
            return this.builder.buildTdmWriter();
        }
        if (constituent instanceof Opm) {
            return this.builder.buildOpmWriter();
        }
        if (constituent instanceof Omm) {
            return this.builder.buildOmmWriter();
        }
        if (constituent instanceof Oem) {
            return this.builder.buildOemWriter();
        }
        if (constituent instanceof Ocm) {
            return this.builder.buildOcmWriter();
        }
        if (constituent instanceof Apm) {
            return this.builder.buildApmWriter();
        }
        if (constituent instanceof Aem) {
            return this.builder.buildAemWriter();
        }
        if (constituent instanceof Acm) {
            return this.builder.buildAcmWriter();
        }
        throw new OrekitInternalError(null);
    }
}

