/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Metadata;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.utils.IERSConventions;

public abstract class NdmConstituent<H extends Header, S extends Segment<?, ?>> {
    private H header;
    private List<S> segments;
    private final IERSConventions conventions;
    private final DataContext dataContext;

    protected NdmConstituent(H header, List<S> segments, IERSConventions conventions, DataContext dataContext) {
        this.header = header;
        this.segments = segments;
        this.conventions = conventions;
        this.dataContext = dataContext;
    }

    public H getHeader() {
        return this.header;
    }

    public void setHeader(H header) {
        this.header = header;
    }

    public List<S> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public void setSegments(List<S> segments) {
        this.segments = segments;
    }

    public IERSConventions getConventions() {
        if (this.conventions != null) {
            return this.conventions;
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public void validate() {
        ((Header)this.header).validate(((Header)this.header).getFormatVersion());
        for (Segment segment : this.segments) {
            ((Metadata)segment.getMetadata()).validate(((Header)this.header).getFormatVersion());
            segment.getData().validate(((Header)this.header).getFormatVersion());
        }
    }
}

