/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import org.hipparchus.complex.Quaternion;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;

public class CommonPhysicalProperties
extends CommentsContainer {
    private FrameFacade oebParentFrame = new FrameFacade(null, null, OrbitRelativeFrame.RIC, null, OrbitRelativeFrame.RIC.name());
    private AbsoluteDate oebParentFrameEpoch = AbsoluteDate.ARBITRARY_EPOCH;
    private final double[] oebQ = new double[4];
    private double oebMax = Double.NaN;
    private double oebIntermediate = Double.NaN;
    private double oebMin = Double.NaN;
    private double oebAreaAlongMax = Double.NaN;
    private double oebAreaAlongIntermediate = Double.NaN;
    private double oebAreaAlongMin = Double.NaN;
    private double rcs = Double.NaN;
    private double minRcs = Double.NaN;
    private double maxRcs = Double.NaN;
    private double vmAbsolute = Double.NaN;
    private double vmApparentMin = Double.NaN;
    private double vmApparent = Double.NaN;
    private double vmApparentMax = Double.NaN;
    private double reflectance = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
    }

    public FrameFacade getOebParentFrame() {
        return this.oebParentFrame;
    }

    public void setOebParentFrame(FrameFacade oebParentFrame) {
        this.refuseFurtherComments();
        this.oebParentFrame = oebParentFrame;
    }

    public AbsoluteDate getOebParentFrameEpoch() {
        return this.oebParentFrameEpoch;
    }

    public void setOebParentFrameEpoch(AbsoluteDate oebParentFrameEpoch) {
        this.refuseFurtherComments();
        this.oebParentFrameEpoch = oebParentFrameEpoch;
    }

    public Quaternion getOebQ() {
        return new Quaternion(this.oebQ[0], this.oebQ[1], this.oebQ[2], this.oebQ[3]);
    }

    public void setOebQ(int i, double qI) {
        this.refuseFurtherComments();
        this.oebQ[i] = qI;
    }

    public double getOebMax() {
        return this.oebMax;
    }

    public void setOebMax(double oebMax) {
        this.refuseFurtherComments();
        this.oebMax = oebMax;
    }

    public double getOebIntermediate() {
        return this.oebIntermediate;
    }

    public void setOebIntermediate(double oebIntermediate) {
        this.refuseFurtherComments();
        this.oebIntermediate = oebIntermediate;
    }

    public double getOebMin() {
        return this.oebMin;
    }

    public void setOebMin(double oebMin) {
        this.refuseFurtherComments();
        this.oebMin = oebMin;
    }

    public double getOebAreaAlongMax() {
        return this.oebAreaAlongMax;
    }

    public void setOebAreaAlongMax(double oebAreaAlongMax) {
        this.refuseFurtherComments();
        this.oebAreaAlongMax = oebAreaAlongMax;
    }

    public double getOebAreaAlongIntermediate() {
        return this.oebAreaAlongIntermediate;
    }

    public void setOebAreaAlongIntermediate(double oebAreaAlongIntermediate) {
        this.refuseFurtherComments();
        this.oebAreaAlongIntermediate = oebAreaAlongIntermediate;
    }

    public double getOebAreaAlongMin() {
        return this.oebAreaAlongMin;
    }

    public void setOebAreaAlongMin(double oebAreaAlongMin) {
        this.refuseFurtherComments();
        this.oebAreaAlongMin = oebAreaAlongMin;
    }

    public double getRcs() {
        return this.rcs;
    }

    public void setRcs(double rcs) {
        this.refuseFurtherComments();
        this.rcs = rcs;
    }

    public double getMinRcs() {
        return this.minRcs;
    }

    public void setMinRcs(double minRcs) {
        this.refuseFurtherComments();
        this.minRcs = minRcs;
    }

    public double getMaxRcs() {
        return this.maxRcs;
    }

    public void setMaxRcs(double maxRcs) {
        this.refuseFurtherComments();
        this.maxRcs = maxRcs;
    }

    public double getVmAbsolute() {
        return this.vmAbsolute;
    }

    public void setVmAbsolute(double vmAbsolute) {
        this.refuseFurtherComments();
        this.vmAbsolute = vmAbsolute;
    }

    public double getVmApparentMin() {
        return this.vmApparentMin;
    }

    public void setVmApparentMin(double vmApparentMin) {
        this.refuseFurtherComments();
        this.vmApparentMin = vmApparentMin;
    }

    public double getVmApparent() {
        return this.vmApparent;
    }

    public void setVmApparent(double vmApparent) {
        this.refuseFurtherComments();
        this.vmApparent = vmApparent;
    }

    public double getVmApparentMax() {
        return this.vmApparentMax;
    }

    public void setVmApparentMax(double vmApparentMax) {
        this.refuseFurtherComments();
        this.vmApparentMax = vmApparentMax;
    }

    public double getReflectance() {
        return this.reflectance;
    }

    public void setReflectance(double reflectance) {
        this.refuseFurtherComments();
        this.reflectance = reflectance;
    }
}

