/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
    private final IERSConventions conventions;
    private final double equatorialRadius;
    private final double flattening;
    private final DataContext dataContext;
    private final AbsoluteDate missionReferenceDate;
    private final RangeUnitsConverter rangeUnitsConverter;

    protected AbstractBuilder(IERSConventions conventions, double equatorialRadius, double flattening, DataContext dataContext, AbsoluteDate missionReferenceDate, RangeUnitsConverter rangeUnitsConverter) {
        this.conventions = conventions;
        this.equatorialRadius = equatorialRadius;
        this.flattening = flattening;
        this.dataContext = dataContext;
        this.missionReferenceDate = missionReferenceDate;
        this.rangeUnitsConverter = rangeUnitsConverter;
    }

    protected abstract T create(IERSConventions var1, double var2, double var4, DataContext var6, AbsoluteDate var7, RangeUnitsConverter var8);

    public T withConventions(IERSConventions newConventions) {
        return this.create(newConventions, this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter());
    }

    public IERSConventions getConventions() {
        return this.conventions;
    }

    public T withEquatorialRadius(double newEquatorialRadius) {
        return this.create(this.getConventions(), newEquatorialRadius, this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter());
    }

    public double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    public T withFlattening(double newFlattening) {
        return this.create(this.getConventions(), this.getEquatorialRadius(), newFlattening, this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter());
    }

    public double getFlattening() {
        return this.flattening;
    }

    public T withDataContext(DataContext newDataContext) {
        return this.create(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), newDataContext, this.getMissionReferenceDate(), this.getRangeUnitsConverter());
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public T withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return this.create(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), newMissionReferenceDate, this.getRangeUnitsConverter());
    }

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    public T withRangeUnitsConverter(RangeUnitsConverter newRangeUnitsConverter) {
        return this.create(this.getConventions(), this.getEquatorialRadius(), this.getFlattening(), this.getDataContext(), this.getMissionReferenceDate(), newRangeUnitsConverter);
    }

    public RangeUnitsConverter getRangeUnitsConverter() {
        return this.rangeUnitsConverter;
    }
}

