/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class SpacecraftBodyFrame {
    private final BaseEquipment baseEquipment;
    private final String label;

    public SpacecraftBodyFrame(BaseEquipment baseEquipment, String label) {
        this.baseEquipment = baseEquipment;
        this.label = label;
    }

    public BaseEquipment getBaseEquipment() {
        return this.baseEquipment;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel().length() > 0 ? this.getBaseEquipment().name() + "_" + this.getLabel() : this.getBaseEquipment().name();
    }

    public static SpacecraftBodyFrame parse(String descriptor) {
        for (BaseEquipment equipment : BaseEquipment.values()) {
            if (!descriptor.startsWith(equipment.name())) continue;
            int index = equipment.name().length();
            if (index < descriptor.length() && descriptor.charAt(index) == '_') {
                ++index;
            }
            return new SpacecraftBodyFrame(equipment, descriptor.substring(index));
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, descriptor);
    }

    public static enum BaseEquipment {
        ACC,
        ACTUATOR,
        AST,
        CSS,
        DSS,
        ESA,
        GYRO_FRAME,
        GYRO,
        IMU_FRAME,
        INSTRUMENT,
        MTA,
        RW,
        SA,
        SC_BODY,
        SENSOR,
        STARTRACKER,
        TAM;

    }
}

