/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import java.util.regex.Pattern;
import org.orekit.files.ccsds.definitions.OdMethodType;

public class OdMethodFacade {
    private static final Pattern SPLITTER = Pattern.compile("\\p{Blank}*:\\p{Blank}*");
    private final String name;
    private final OdMethodType type;
    private final String tool;

    public OdMethodFacade(String name, OdMethodType type, String tool) {
        this.name = name;
        this.type = type;
        this.tool = tool;
    }

    public String getName() {
        return this.name;
    }

    public OdMethodType getType() {
        return this.type;
    }

    public String getTool() {
        return this.tool;
    }

    public static OdMethodFacade parse(String s) {
        String[] fields = SPLITTER.split(s);
        if (fields.length == 2) {
            OdMethodType type;
            try {
                type = OdMethodType.valueOf(fields[0]);
            }
            catch (IllegalArgumentException iae) {
                type = null;
            }
            return new OdMethodFacade(fields[0], type, fields[1]);
        }
        return new OdMethodFacade(s, null, null);
    }
}

