/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.CelestialBodyFrame;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.files.ccsds.definitions.SpacecraftBodyFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinatesProvider;

public class FrameFacade {
    private final Frame frame;
    private final CelestialBodyFrame celestialBodyFrame;
    private final OrbitRelativeFrame orbitRelativeFrame;
    private final SpacecraftBodyFrame spacecraftBodyFrame;
    private final String name;

    public FrameFacade(Frame frame, CelestialBodyFrame celestialBodyFrame, OrbitRelativeFrame orbitRelativeFrame, SpacecraftBodyFrame spacecraftBodyFrame, String name) {
        this.frame = frame;
        this.celestialBodyFrame = celestialBodyFrame;
        this.orbitRelativeFrame = orbitRelativeFrame;
        this.spacecraftBodyFrame = spacecraftBodyFrame;
        this.name = name;
    }

    public Frame asFrame() {
        return this.frame;
    }

    public CelestialBodyFrame asCelestialBodyFrame() {
        return this.celestialBodyFrame;
    }

    public OrbitRelativeFrame asOrbitRelativeFrame() {
        return this.orbitRelativeFrame;
    }

    public SpacecraftBodyFrame asSpacecraftBodyFrame() {
        return this.spacecraftBodyFrame;
    }

    public String getName() {
        return this.name;
    }

    public static FrameFacade map(Frame frame) {
        CelestialBodyFrame cbf = CelestialBodyFrame.map(frame);
        return new FrameFacade(frame, cbf, null, null, cbf.getName());
    }

    public static FrameFacade parse(String name, IERSConventions conventions, boolean simpleEOP, DataContext dataContext, boolean allowCelestial, boolean allowOrbit, boolean allowSpacecraft) {
        try {
            CelestialBodyFrame cbf = CelestialBodyFrame.parse(name);
            if (allowCelestial) {
                return new FrameFacade(cbf.getFrame(conventions, simpleEOP, dataContext), cbf, null, null, cbf.getName());
            }
        }
        catch (IllegalArgumentException iaeC) {
            try {
                OrbitRelativeFrame orf = OrbitRelativeFrame.valueOf(name.replace(' ', '_'));
                if (allowOrbit) {
                    return new FrameFacade(null, null, orf, null, orf.name());
                }
            }
            catch (IllegalArgumentException iaeO) {
                try {
                    SpacecraftBodyFrame sbf = SpacecraftBodyFrame.parse(name.replace(' ', '_'));
                    if (allowSpacecraft) {
                        return new FrameFacade(null, null, null, sbf, sbf.toString());
                    }
                }
                catch (IllegalArgumentException | OrekitException runtimeException) {
                    // empty catch block
                }
            }
        }
        return new FrameFacade(null, null, null, null, name);
    }

    public static Transform getTransform(FrameFacade frameIn, FrameFacade frameOut, Frame inertialPivotFrame, AbsoluteDate date, PVCoordinatesProvider pv) {
        if (inertialPivotFrame.isPseudoInertial()) {
            Transform frameInToPivot = FrameFacade.getTransformToPivot(frameIn, inertialPivotFrame, date, pv);
            Transform pivotToFrameOut = FrameFacade.getTransformToPivot(frameOut, inertialPivotFrame, date, pv).getInverse();
            return new Transform(date, frameInToPivot, pivotToFrameOut);
        }
        throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, inertialPivotFrame.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Transform getTransformToPivot(FrameFacade frameIn, Frame inertialPivotFrame, AbsoluteDate date, PVCoordinatesProvider pv) {
        if (frameIn.asFrame() != null) {
            return frameIn.asFrame().getTransformTo(inertialPivotFrame, date);
        }
        if (frameIn.asOrbitRelativeFrame() != null) {
            LOFType lofIn = frameIn.asOrbitRelativeFrame().getLofType();
            if (lofIn == null) throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_TRANSFORM, frameIn.getName(), inertialPivotFrame.getName());
            return lofIn.transformFromInertial(date, pv.getPVCoordinates(date, inertialPivotFrame)).getInverse();
        }
        if (frameIn.asCelestialBodyFrame() == null) throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_TRANSFORM, frameIn.getName(), inertialPivotFrame.getName());
        throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_TRANSFORM, frameIn.asCelestialBodyFrame().getName(), inertialPivotFrame.getName());
    }
}

