/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.unscented.UnscentedEvolution;
import org.hipparchus.filtering.kalman.unscented.UnscentedProcess;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimationCommon;
import org.orekit.estimation.sequential.KalmanEstimatorUtil;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class UnscentedKalmanModel
extends KalmanEstimationCommon
implements UnscentedProcess<MeasurementDecorator> {
    private final double[] referenceValues;

    protected UnscentedKalmanModel(List<PropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        super(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementParameters, measurementProcessNoiseMatrix);
        int stateDimension = 0;
        for (ParameterDriver parameterDriver : this.getEstimatedOrbitalParameters().getDrivers()) {
            ++stateDimension;
        }
        for (ParameterDriver parameterDriver : this.getEstimatedPropagationParameters().getDrivers()) {
            ++stateDimension;
        }
        for (ParameterDriver parameterDriver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            ++stateDimension;
        }
        this.referenceValues = new double[stateDimension];
        int index = 0;
        for (ParameterDriver parameterDriver : this.getEstimatedOrbitalParameters().getDrivers()) {
            this.referenceValues[index++] = parameterDriver.getReferenceValue();
        }
        for (ParameterDriver parameterDriver : this.getEstimatedPropagationParameters().getDrivers()) {
            this.referenceValues[index++] = parameterDriver.getReferenceValue();
        }
        for (ParameterDriver parameterDriver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            this.referenceValues[index++] = parameterDriver.getReferenceValue();
        }
    }

    public UnscentedEvolution getEvolution(double previousTime, RealVector[] sigmaPoints, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (driver.getReferenceDate() != null) continue;
            driver.setReferenceDate(((PropagatorBuilder)this.getBuilders().get(0)).getInitialOrbitDate());
        }
        this.incrementCurrentMeasurementNumber();
        this.setCurrentDate(measurement.getObservedMeasurement().getDate());
        RealVector[] predictedSigmaPoints = new RealVector[sigmaPoints.length];
        for (int i = sigmaPoints.length - 1; i >= 0; --i) {
            RealVector sigmaPoint = sigmaPoints[i].copy();
            this.updateParameters(sigmaPoint);
            Propagator[] propagators = this.getEstimatedPropagators();
            predictedSigmaPoints[i] = this.predictState(observedMeasurement.getDate(), sigmaPoint, propagators, i != 0);
        }
        int d = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            driver.setReferenceValue(this.referenceValues[d]);
            driver.setNormalizedValue(predictedSigmaPoints[0].getEntry(d));
            this.referenceValues[d] = driver.getValue();
            for (int i = 1; i < predictedSigmaPoints.length; ++i) {
                predictedSigmaPoints[i].setEntry(d, predictedSigmaPoints[i].getEntry(d) - predictedSigmaPoints[0].getEntry(d));
            }
            predictedSigmaPoints[0].setEntry(d, 0.0);
            ++d;
        }
        RealMatrix normalizedProcessNoise = this.getNormalizedProcessNoise(sigmaPoints[0].getDimension());
        return new UnscentedEvolution(measurement.getTime(), predictedSigmaPoints, normalizedProcessNoise);
    }

    public RealVector[] getPredictedMeasurements(RealVector[] predictedSigmaPoints, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        RealVector theoreticalStandardDeviation = MatrixUtils.createRealVector((double[])observedMeasurement.getTheoreticalStandardDeviation());
        RealVector[] predictedMeasurements = new RealVector[predictedSigmaPoints.length];
        for (int i = 0; i < predictedSigmaPoints.length; ++i) {
            RealVector predictedSigmaPoint = predictedSigmaPoints[i].copy();
            this.updateParameters(predictedSigmaPoint);
            Propagator[] propagators = this.getEstimatedPropagators();
            SpacecraftState[] predictedStates = new SpacecraftState[propagators.length];
            for (int k = 0; k < propagators.length; ++k) {
                predictedStates[k] = propagators[k].getInitialState();
            }
            EstimatedMeasurement<?> estimated = UnscentedKalmanModel.estimateMeasurement(observedMeasurement, this.getCurrentMeasurementNumber(), KalmanEstimatorUtil.filterRelevant(observedMeasurement, predictedStates));
            predictedMeasurements[i] = new ArrayRealVector(estimated.getEstimatedValue()).ebeDivide(theoreticalStandardDeviation);
        }
        return predictedMeasurements;
    }

    public RealVector getInnovation(MeasurementDecorator measurement, RealVector predictedMeas, RealVector predictedState, RealMatrix innovationCovarianceMatrix) {
        RealVector predictedStateCopy = predictedState.copy();
        this.updateParameters(predictedStateCopy);
        RealVector theoreticalStandardDeviation = MatrixUtils.createRealVector((double[])measurement.getObservedMeasurement().getTheoreticalStandardDeviation());
        Propagator[] propagators = this.getEstimatedPropagators();
        for (int k = 0; k < propagators.length; ++k) {
            this.setPredictedSpacecraftState(propagators[k].getInitialState(), k);
        }
        EstimatedMeasurement<?> predictedMeasurement = UnscentedKalmanModel.estimateMeasurement(measurement.getObservedMeasurement(), this.getCurrentMeasurementNumber(), KalmanEstimatorUtil.filterRelevant(measurement.getObservedMeasurement(), this.getPredictedSpacecraftStates()));
        this.setPredictedMeasurement(predictedMeasurement);
        predictedMeasurement.setEstimatedValue(predictedMeas.ebeMultiply(theoreticalStandardDeviation).toArray());
        KalmanEstimatorUtil.applyDynamicOutlierFilter(predictedMeasurement, innovationCovarianceMatrix);
        return KalmanEstimatorUtil.computeInnovationVector(predictedMeasurement, predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    private RealVector predictState(AbsoluteDate date, RealVector previousState, Propagator[] propagators, boolean resetState) {
        RealVector predictedState = previousState.copy();
        int jOrb = 0;
        for (int k = 0; k < propagators.length; ++k) {
            SpacecraftState originalState = propagators[k].getInitialState();
            SpacecraftState predicted = propagators[k].propagate(date);
            ((PropagatorBuilder)this.getBuilders().get(k)).resetOrbit(predicted.getOrbit());
            if (this.getBuilders().get(k) instanceof AbstractPropagatorBuilder) {
                ((AbstractPropagatorBuilder)this.getBuilders().get(k)).setMass(predicted.getMass());
            }
            for (ParameterDriversList.DelegatingDriver orbitalDriver : ((PropagatorBuilder)this.getBuilders().get(k)).getOrbitalParametersDrivers().getDrivers()) {
                if (!orbitalDriver.isSelected()) continue;
                orbitalDriver.setReferenceValue(this.referenceValues[jOrb]);
                predictedState.setEntry(jOrb, orbitalDriver.getNormalizedValue());
                ++jOrb;
            }
            if (!resetState) continue;
            ((PropagatorBuilder)this.getBuilders().get(k)).resetOrbit(originalState.getOrbit());
        }
        return predictedState;
    }

    public void finalizeEstimation(ObservedMeasurement<?> observedMeasurement, ProcessEstimate estimate) {
        this.setCorrectedEstimate(estimate);
        this.updateParameters(estimate.getState());
        Propagator[] estimatedPropagators = this.getEstimatedPropagators();
        for (int k = 0; k < estimatedPropagators.length; ++k) {
            this.setCorrectedSpacecraftState(estimatedPropagators[k].getInitialState(), k);
        }
        this.setCorrectedMeasurement(UnscentedKalmanModel.estimateMeasurement(observedMeasurement, this.getCurrentMeasurementNumber(), KalmanEstimatorUtil.filterRelevant(observedMeasurement, this.getCorrectedSpacecraftStates())));
    }

    private static <T extends ObservedMeasurement<T>> EstimatedMeasurement<T> estimateMeasurement(ObservedMeasurement<T> observedMeasurement, int measurementNumber, SpacecraftState[] spacecraftStates) {
        EstimatedMeasurementBase<T> estimatedMeasurementBase = observedMeasurement.estimateWithoutDerivatives(measurementNumber, measurementNumber, KalmanEstimatorUtil.filterRelevant(observedMeasurement, spacecraftStates));
        return new EstimatedMeasurement<T>(estimatedMeasurementBase);
    }

    private void updateParameters(RealVector normalizedState) {
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            driver.setReferenceValue(this.referenceValues[i]);
            driver.setNormalizedValue(normalizedState.getEntry(i));
            normalizedState.setEntry(i++, driver.getNormalizedValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            driver.setNormalizedValue(normalizedState.getEntry(i));
            normalizedState.setEntry(i++, driver.getNormalizedValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            driver.setNormalizedValue(normalizedState.getEntry(i));
            normalizedState.setEntry(i++, driver.getNormalizedValue());
        }
    }
}

