/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.QRDecomposer;
import org.hipparchus.util.UnscentedTransformProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.UnscentedKalmanEstimator;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.utils.ParameterDriversList;

public class UnscentedKalmanEstimatorBuilder {
    private MatrixDecomposer decomposer = new QRDecomposer(1.0E-15);
    private List<PropagatorBuilder> propagatorBuilders = new ArrayList<PropagatorBuilder>();
    private ParameterDriversList estimatedMeasurementsParameters = new ParameterDriversList();
    private List<CovarianceMatrixProvider> processNoiseMatrixProviders = new ArrayList<CovarianceMatrixProvider>();
    private CovarianceMatrixProvider measurementProcessNoiseMatrix = null;
    private UnscentedTransformProvider utProvider = null;

    public UnscentedKalmanEstimator build() {
        if (this.propagatorBuilders.size() == 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_PROPAGATOR_CONFIGURED, new Object[0]);
        }
        if (this.utProvider == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_UNSCENTED_TRANSFORM_CONFIGURED, new Object[0]);
        }
        return new UnscentedKalmanEstimator(this.decomposer, this.propagatorBuilders, this.processNoiseMatrixProviders, this.estimatedMeasurementsParameters, this.measurementProcessNoiseMatrix, this.utProvider);
    }

    public UnscentedKalmanEstimatorBuilder decomposer(MatrixDecomposer matrixDecomposer) {
        this.decomposer = matrixDecomposer;
        return this;
    }

    public UnscentedKalmanEstimatorBuilder unscentedTransformProvider(UnscentedTransformProvider transformProvider) {
        this.utProvider = transformProvider;
        return this;
    }

    public UnscentedKalmanEstimatorBuilder addPropagationConfiguration(PropagatorBuilder builder, CovarianceMatrixProvider provider) {
        this.propagatorBuilders.add(builder);
        this.processNoiseMatrixProviders.add(provider);
        return this;
    }

    public UnscentedKalmanEstimatorBuilder estimatedMeasurementsParameters(ParameterDriversList estimatedMeasurementsParams, CovarianceMatrixProvider provider) {
        this.estimatedMeasurementsParameters = estimatedMeasurementsParams;
        this.measurementProcessNoiseMatrix = provider;
        return this;
    }
}

