/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.unscented.UnscentedKalmanFilter;
import org.hipparchus.filtering.kalman.unscented.UnscentedProcess;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.util.UnscentedTransformProvider;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.AbstractKalmanEstimator;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanEstimatorUtil;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.UnscentedKalmanModel;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriversList;

public class UnscentedKalmanEstimator
extends AbstractKalmanEstimator {
    private final AbsoluteDate referenceDate;
    private final UnscentedKalmanModel processModel;
    private final UnscentedKalmanFilter<MeasurementDecorator> filter;
    private KalmanObserver observer;

    UnscentedKalmanEstimator(MatrixDecomposer decomposer, List<PropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> processNoiseMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix, UnscentedTransformProvider utProvider) {
        super(propagatorBuilders);
        this.referenceDate = propagatorBuilders.get(0).getInitialOrbitDate();
        this.observer = null;
        this.processModel = new UnscentedKalmanModel(propagatorBuilders, processNoiseMatricesProviders, estimatedMeasurementParameters, measurementProcessNoiseMatrix);
        this.filter = new UnscentedKalmanFilter(decomposer, (UnscentedProcess)this.processModel, this.processModel.getEstimate(), utProvider);
    }

    @Override
    protected KalmanEstimation getKalmanEstimation() {
        return this.processModel;
    }

    public void setObserver(KalmanObserver observer) {
        this.observer = observer;
    }

    public Propagator[] estimationStep(ObservedMeasurement<?> observedMeasurement) {
        ProcessEstimate estimate = this.filter.estimationStep((Measurement)KalmanEstimatorUtil.decorate(observedMeasurement, this.referenceDate));
        this.processModel.finalizeEstimation(observedMeasurement, estimate);
        if (this.observer != null) {
            this.observer.evaluationPerformed(this.processModel);
        }
        return this.processModel.getEstimatedPropagators();
    }

    public Propagator[] processMeasurements(Iterable<ObservedMeasurement<?>> observedMeasurements) {
        Propagator[] propagators = null;
        for (ObservedMeasurement<?> observedMeasurement : observedMeasurements) {
            propagators = this.estimationStep(observedMeasurement);
        }
        return propagators;
    }
}

