/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.estimation.sequential.AbstractCovarianceMatrixProvider;
import org.orekit.frames.LOFType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.StateCovariance;

public class UnivariateProcessNoise
extends AbstractCovarianceMatrixProvider {
    private final LOFType lofType;
    private final PositionAngleType positionAngleType;
    private final UnivariateFunction[] lofCartesianOrbitalParametersEvolution;
    private final UnivariateFunction[] propagationParametersEvolution;
    private final UnivariateFunction[] measurementsParametersEvolution;

    public UnivariateProcessNoise(RealMatrix initialCovarianceMatrix, LOFType lofType, PositionAngleType positionAngleType, UnivariateFunction[] lofCartesianOrbitalParametersEvolution, UnivariateFunction[] propagationParametersEvolution) {
        this(initialCovarianceMatrix, lofType, positionAngleType, lofCartesianOrbitalParametersEvolution, propagationParametersEvolution, new UnivariateFunction[0]);
    }

    public UnivariateProcessNoise(RealMatrix initialCovarianceMatrix, LOFType lofType, PositionAngleType positionAngleType, UnivariateFunction[] lofCartesianOrbitalParametersEvolution, UnivariateFunction[] propagationParametersEvolution, UnivariateFunction[] measurementsParametersEvolution) {
        super(initialCovarianceMatrix);
        this.lofType = lofType;
        this.positionAngleType = positionAngleType;
        this.lofCartesianOrbitalParametersEvolution = (UnivariateFunction[])lofCartesianOrbitalParametersEvolution.clone();
        this.propagationParametersEvolution = (UnivariateFunction[])propagationParametersEvolution.clone();
        this.measurementsParametersEvolution = (UnivariateFunction[])measurementsParametersEvolution.clone();
    }

    public LOFType getLofType() {
        return this.lofType;
    }

    public PositionAngleType getPositionAngleType() {
        return this.positionAngleType;
    }

    public UnivariateFunction[] getLofCartesianOrbitalParametersEvolution() {
        return (UnivariateFunction[])this.lofCartesianOrbitalParametersEvolution.clone();
    }

    public UnivariateFunction[] getPropagationParametersEvolution() {
        return (UnivariateFunction[])this.propagationParametersEvolution.clone();
    }

    public UnivariateFunction[] getMeasurementsParametersEvolution() {
        return (UnivariateFunction[])this.measurementsParametersEvolution.clone();
    }

    @Override
    public RealMatrix getProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        int nbOrb = this.lofCartesianOrbitalParametersEvolution.length;
        int nbPropag = this.propagationParametersEvolution.length;
        int nbMeas = this.measurementsParametersEvolution.length;
        RealMatrix processNoiseMatrix = MatrixUtils.createRealMatrix((int)(nbOrb + nbPropag + nbMeas), (int)(nbOrb + nbPropag + nbMeas));
        if (nbOrb != 0) {
            RealMatrix inertialOrbitalProcessNoiseMatrix = this.getInertialOrbitalProcessNoiseMatrix(previous, current);
            processNoiseMatrix.setSubMatrix(inertialOrbitalProcessNoiseMatrix.getData(), 0, 0);
        }
        if (nbPropag != 0) {
            RealMatrix propagationProcessNoiseMatrix = this.getPropagationProcessNoiseMatrix(previous, current);
            processNoiseMatrix.setSubMatrix(propagationProcessNoiseMatrix.getData(), nbOrb, nbOrb);
        }
        if (nbMeas != 0) {
            RealMatrix measurementsProcessNoiseMatrix = this.getMeasurementsProcessNoiseMatrix(previous, current);
            processNoiseMatrix.setSubMatrix(measurementsProcessNoiseMatrix.getData(), nbOrb + nbPropag, nbOrb + nbPropag);
        }
        return processNoiseMatrix;
    }

    private RealMatrix getInertialOrbitalProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int lofOrbitalProcessNoiseLength = this.lofCartesianOrbitalParametersEvolution.length;
        double[] lofOrbitalProcessNoiseValues = new double[lofOrbitalProcessNoiseLength];
        for (int i = 0; i < lofOrbitalProcessNoiseLength; ++i) {
            double functionValue = this.lofCartesianOrbitalParametersEvolution[i].value(deltaT);
            lofOrbitalProcessNoiseValues[i] = functionValue * functionValue;
        }
        RealMatrix lofCartesianProcessNoiseMatrix = MatrixUtils.createRealDiagonalMatrix((double[])lofOrbitalProcessNoiseValues);
        StateCovariance lofCartesianProcessNoiseCov = new StateCovariance(lofCartesianProcessNoiseMatrix, current.getDate(), this.lofType);
        StateCovariance inertialCartesianProcessNoiseCov = lofCartesianProcessNoiseCov.changeCovarianceFrame(current.getOrbit(), current.getFrame());
        StateCovariance inertialOrbitalProcessNoiseCov = inertialCartesianProcessNoiseCov.changeCovarianceType(current.getOrbit(), current.getOrbit().getType(), this.positionAngleType);
        return inertialOrbitalProcessNoiseCov.getMatrix();
    }

    private RealMatrix getPropagationProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int propagationProcessNoiseLength = this.propagationParametersEvolution.length;
        double[] propagationProcessNoiseValues = new double[propagationProcessNoiseLength];
        for (int i = 0; i < propagationProcessNoiseLength; ++i) {
            double functionValue = this.propagationParametersEvolution[i].value(deltaT);
            propagationProcessNoiseValues[i] = functionValue * functionValue;
        }
        return MatrixUtils.createRealDiagonalMatrix((double[])propagationProcessNoiseValues);
    }

    private RealMatrix getMeasurementsProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int measurementsProcessNoiseLength = this.measurementsParametersEvolution.length;
        double[] measurementsProcessNoiseValues = new double[measurementsProcessNoiseLength];
        for (int i = 0; i < measurementsProcessNoiseLength; ++i) {
            double functionValue = this.measurementsParametersEvolution[i].value(deltaT);
            measurementsProcessNoiseValues[i] = functionValue * functionValue;
        }
        return MatrixUtils.createRealDiagonalMatrix((double[])measurementsProcessNoiseValues);
    }
}

