/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.hipparchus.filtering.kalman.KalmanFilter;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.unscented.UnscentedEvolution;
import org.hipparchus.filtering.kalman.unscented.UnscentedKalmanFilter;
import org.hipparchus.filtering.kalman.unscented.UnscentedProcess;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanEstimatorUtil;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalMeasurementHandler;
import org.orekit.estimation.sequential.SemiAnalyticalProcess;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class SemiAnalyticalUnscentedKalmanModel
implements KalmanEstimation,
UnscentedProcess<MeasurementDecorator>,
SemiAnalyticalProcess {
    private final DSSTPropagatorBuilder builder;
    private final ParameterDriversList estimatedOrbitalParameters;
    private final ParameterDriversList estimatedPropagationParameters;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final CovarianceMatrixProvider covarianceMatrixProvider;
    private final CovarianceMatrixProvider measurementProcessNoiseMatrix;
    private final PositionAngleType angleType;
    private final OrbitType orbitType;
    private ProcessEstimate correctedEstimate;
    private KalmanObserver observer;
    private int currentMeasurementNumber;
    private AbsoluteDate currentDate;
    private SpacecraftState nominalMeanSpacecraftState;
    private SpacecraftState previousNominalMeanSpacecraftState;
    private SpacecraftState predictedSpacecraftState;
    private SpacecraftState correctedSpacecraftState;
    private EstimatedMeasurement<?> predictedMeasurement;
    private EstimatedMeasurement<?> correctedMeasurement;
    private RealVector predictedFilterCorrection;
    private RealVector correctedFilterCorrection;
    private DSSTPropagator dsstPropagator;
    private RealVector shortPeriodicTerms;

    protected SemiAnalyticalUnscentedKalmanModel(DSSTPropagatorBuilder propagatorBuilder, CovarianceMatrixProvider covarianceMatrixProvider, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        SpacecraftState meanState;
        this.builder = propagatorBuilder;
        this.angleType = propagatorBuilder.getPositionAngleType();
        this.orbitType = propagatorBuilder.getOrbitType();
        this.estimatedMeasurementsParameters = estimatedMeasurementParameters;
        this.currentMeasurementNumber = 0;
        this.currentDate = propagatorBuilder.getInitialOrbitDate();
        this.covarianceMatrixProvider = covarianceMatrixProvider;
        this.measurementProcessNoiseMatrix = measurementProcessNoiseMatrix;
        int columns = 0;
        this.estimatedOrbitalParameters = new ParameterDriversList();
        for (ParameterDriver parameterDriver : propagatorBuilder.getOrbitalParametersDrivers().getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            if (!parameterDriver.isSelected()) continue;
            this.estimatedOrbitalParameters.add(parameterDriver);
            ++columns;
        }
        this.estimatedPropagationParameters = new ParameterDriversList();
        ArrayList<String> estimatedPropagationParametersNames = new ArrayList<String>();
        for (ParameterDriver parameterDriver : propagatorBuilder.getPropagationParametersDrivers().getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            if (!parameterDriver.isSelected()) continue;
            this.estimatedPropagationParameters.add(parameterDriver);
            String driverName = parameterDriver.getName();
            if (estimatedPropagationParametersNames.contains(driverName)) continue;
            estimatedPropagationParametersNames.add(driverName);
            ++columns;
        }
        estimatedPropagationParametersNames.sort(Comparator.naturalOrder());
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            ++columns;
        }
        int n = estimatedMeasurementParameters.getNbParams();
        int n2 = this.estimatedOrbitalParameters.getNbParams() + this.estimatedPropagationParameters.getNbParams();
        this.dsstPropagator = this.getEstimatedPropagator();
        this.nominalMeanSpacecraftState = meanState = this.dsstPropagator.initialIsOsculating() ? DSSTPropagator.computeMeanState(this.dsstPropagator.getInitialState(), this.dsstPropagator.getAttitudeProvider(), this.dsstPropagator.getAllForceModels()) : this.dsstPropagator.getInitialState();
        this.correctedSpacecraftState = this.predictedSpacecraftState = meanState;
        this.previousNominalMeanSpacecraftState = this.nominalMeanSpacecraftState;
        this.correctedFilterCorrection = this.predictedFilterCorrection = MatrixUtils.createRealVector((int)columns);
        RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(n2 + n), (int)(n2 + n));
        RealMatrix noiseP = covarianceMatrixProvider.getInitialCovarianceMatrix(this.nominalMeanSpacecraftState);
        noiseK.setSubMatrix(noiseP.getData(), 0, 0);
        if (measurementProcessNoiseMatrix != null) {
            RealMatrix noiseM = measurementProcessNoiseMatrix.getInitialCovarianceMatrix(this.nominalMeanSpacecraftState);
            noiseK.setSubMatrix(noiseM.getData(), n2, n2);
        }
        KalmanEstimatorUtil.checkDimension(noiseK.getRowDimension(), propagatorBuilder.getOrbitalParametersDrivers(), propagatorBuilder.getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
        this.correctedEstimate = new ProcessEstimate(0.0, this.correctedFilterCorrection, noiseK);
    }

    @Override
    public KalmanObserver getObserver() {
        return this.observer;
    }

    public void setObserver(KalmanObserver observer) {
        this.observer = observer;
    }

    public ProcessEstimate getEstimate() {
        return this.correctedEstimate;
    }

    public DSSTPropagator processMeasurements(List<ObservedMeasurement<?>> observedMeasurements, UnscentedKalmanFilter<MeasurementDecorator> filter) {
        observedMeasurements.sort(new ChronologicalComparator());
        AbsoluteDate tStart = observedMeasurements.get(0).getDate();
        AbsoluteDate tEnd = observedMeasurements.get(observedMeasurements.size() - 1).getDate();
        double overshootTimeRange = FastMath.nextAfter((double)tEnd.durationFrom(tStart), (double)Double.POSITIVE_INFINITY);
        SemiAnalyticalMeasurementHandler stepHandler = new SemiAnalyticalMeasurementHandler(this, (KalmanFilter<MeasurementDecorator>)filter, observedMeasurements, this.builder.getInitialOrbitDate(), true);
        this.dsstPropagator.getMultiplexer().add(stepHandler);
        this.dsstPropagator.propagate(tStart, tStart.shiftedBy(overshootTimeRange));
        return this.getEstimatedPropagator();
    }

    public DSSTPropagator getEstimatedPropagator() {
        return (DSSTPropagator)this.builder.buildPropagator();
    }

    public UnscentedEvolution getEvolution(double previousTime, RealVector[] sigmaPoints, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (driver.getReferenceDate() != null) continue;
            driver.setReferenceDate(this.builder.getInitialOrbitDate());
        }
        ++this.currentMeasurementNumber;
        this.currentDate = measurement.getObservedMeasurement().getDate();
        RealMatrix stm = this.getStm();
        RealVector[] predictedStates = new RealVector[sigmaPoints.length];
        for (int k = 0; k < sigmaPoints.length; ++k) {
            RealVector predicted;
            predictedStates[k] = predicted = stm.operate(sigmaPoints[k]);
        }
        int nbMeas = this.getNumberSelectedMeasurementDrivers();
        int nbDyn = this.getNumberSelectedOrbitalDrivers() + this.getNumberSelectedPropagationDrivers();
        RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(nbDyn + nbMeas), (int)(nbDyn + nbMeas));
        RealMatrix noiseP = this.covarianceMatrixProvider.getProcessNoiseMatrix(this.previousNominalMeanSpacecraftState, this.nominalMeanSpacecraftState);
        noiseK.setSubMatrix(noiseP.getData(), 0, 0);
        if (this.measurementProcessNoiseMatrix != null) {
            RealMatrix noiseM = this.measurementProcessNoiseMatrix.getProcessNoiseMatrix(this.previousNominalMeanSpacecraftState, this.nominalMeanSpacecraftState);
            noiseK.setSubMatrix(noiseM.getData(), nbDyn, nbDyn);
        }
        KalmanEstimatorUtil.checkDimension(noiseK.getRowDimension(), this.builder.getOrbitalParametersDrivers(), this.builder.getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
        return new UnscentedEvolution(measurement.getTime(), predictedStates, noiseK);
    }

    public RealVector[] getPredictedMeasurements(RealVector[] predictedSigmaPoints, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        RealVector[] predictedMeasurements = new RealVector[predictedSigmaPoints.length];
        for (int k = 0; k < predictedSigmaPoints.length; ++k) {
            RealVector osculating = this.computeOsculatingElements(predictedSigmaPoints[k], this.nominalMeanSpacecraftState, this.shortPeriodicTerms);
            Orbit osculatingOrbit = this.orbitType.mapArrayToOrbit(osculating.toArray(), null, this.angleType, this.currentDate, this.builder.getMu(), this.builder.getFrame());
            EstimatedMeasurement<?> estimated = SemiAnalyticalUnscentedKalmanModel.estimateMeasurement(observedMeasurement, this.currentMeasurementNumber, new SpacecraftState[]{new SpacecraftState(osculatingOrbit)});
            predictedMeasurements[k] = new ArrayRealVector(estimated.getEstimatedValue());
        }
        return predictedMeasurements;
    }

    public RealVector getInnovation(MeasurementDecorator measurement, RealVector predictedMeas, RealVector predictedState, RealMatrix innovationCovarianceMatrix) {
        this.predictedFilterCorrection = predictedState;
        RealVector osculating = this.computeOsculatingElements(this.predictedFilterCorrection, this.nominalMeanSpacecraftState, this.shortPeriodicTerms);
        Orbit osculatingOrbit = this.orbitType.mapArrayToOrbit(osculating.toArray(), null, this.angleType, this.currentDate, this.builder.getMu(), this.builder.getFrame());
        this.predictedSpacecraftState = new SpacecraftState(osculatingOrbit);
        this.predictedMeasurement = SemiAnalyticalUnscentedKalmanModel.estimateMeasurement(measurement.getObservedMeasurement(), this.currentMeasurementNumber, this.getPredictedSpacecraftStates());
        this.predictedMeasurement.setEstimatedValue(predictedMeas.toArray());
        KalmanEstimatorUtil.applyDynamicOutlierFilter(this.predictedMeasurement, innovationCovarianceMatrix);
        return KalmanEstimatorUtil.computeInnovationVector(this.predictedMeasurement);
    }

    @Override
    public void finalizeEstimation(ObservedMeasurement<?> observedMeasurement, ProcessEstimate estimate) {
        this.correctedEstimate = estimate;
        this.correctedFilterCorrection = estimate.getState();
        this.previousNominalMeanSpacecraftState = this.nominalMeanSpacecraftState;
        RealVector osculating = this.computeOsculatingElements(this.correctedFilterCorrection, this.nominalMeanSpacecraftState, this.shortPeriodicTerms);
        Orbit osculatingOrbit = this.orbitType.mapArrayToOrbit(osculating.toArray(), null, this.builder.getPositionAngleType(), this.currentDate, this.builder.getMu(), this.builder.getFrame());
        this.correctedSpacecraftState = new SpacecraftState(osculatingOrbit);
        this.correctedMeasurement = SemiAnalyticalUnscentedKalmanModel.estimateMeasurement(observedMeasurement, this.currentMeasurementNumber, this.getCorrectedSpacecraftStates());
        if (this.observer != null) {
            this.observer.evaluationPerformed(this);
        }
    }

    private static <T extends ObservedMeasurement<T>> EstimatedMeasurement<?> estimateMeasurement(ObservedMeasurement<T> observedMeasurement, int measurementNumber, SpacecraftState[] spacecraftStates) {
        EstimatedMeasurementBase<T> estimatedMeasurementBase = observedMeasurement.estimateWithoutDerivatives(measurementNumber, measurementNumber, KalmanEstimatorUtil.filterRelevant(observedMeasurement, spacecraftStates));
        EstimatedMeasurement<T> estimatedMeasurement = new EstimatedMeasurement<T>(estimatedMeasurementBase.getObservedMeasurement(), estimatedMeasurementBase.getIteration(), estimatedMeasurementBase.getCount(), estimatedMeasurementBase.getStates(), estimatedMeasurementBase.getParticipants());
        estimatedMeasurement.setEstimatedValue(estimatedMeasurementBase.getEstimatedValue());
        return estimatedMeasurement;
    }

    private RealMatrix getStm() {
        int nbDym = this.getNumberSelectedOrbitalDrivers() + this.getNumberSelectedPropagationDrivers();
        int nbMeas = this.getNumberSelectedMeasurementDrivers();
        RealMatrix stm = MatrixUtils.createRealIdentityMatrix((int)(nbDym + nbMeas));
        double mu = this.builder.getMu();
        double sma = this.previousNominalMeanSpacecraftState.getA();
        double dt = this.currentDate.durationFrom(this.previousNominalMeanSpacecraftState.getDate());
        double contribution = -1.5 * dt * FastMath.sqrt((double)(mu / FastMath.pow((double)sma, (int)5)));
        stm.setEntry(5, 0, contribution);
        return stm;
    }

    @Override
    public void finalizeOperationsObservationGrid() {
        this.updateParameters();
    }

    @Override
    public ParameterDriversList getEstimatedOrbitalParameters() {
        return this.estimatedOrbitalParameters;
    }

    @Override
    public ParameterDriversList getEstimatedPropagationParameters() {
        return this.estimatedPropagationParameters;
    }

    @Override
    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.estimatedMeasurementsParameters;
    }

    @Override
    public SpacecraftState[] getPredictedSpacecraftStates() {
        return new SpacecraftState[]{this.predictedSpacecraftState};
    }

    @Override
    public SpacecraftState[] getCorrectedSpacecraftStates() {
        return new SpacecraftState[]{this.correctedSpacecraftState};
    }

    @Override
    public RealVector getPhysicalEstimatedState() {
        ArrayRealVector physicalEstimatedState = new ArrayRealVector(this.getEstimate().getState().getDimension());
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        return physicalEstimatedState;
    }

    @Override
    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        return this.correctedEstimate.getCovariance();
    }

    @Override
    public RealMatrix getPhysicalStateTransitionMatrix() {
        return null;
    }

    @Override
    public RealMatrix getPhysicalMeasurementJacobian() {
        return null;
    }

    @Override
    public RealMatrix getPhysicalInnovationCovarianceMatrix() {
        return this.correctedEstimate.getInnovationCovariance();
    }

    @Override
    public RealMatrix getPhysicalKalmanGain() {
        return this.correctedEstimate.getKalmanGain();
    }

    @Override
    public int getCurrentMeasurementNumber() {
        return this.currentMeasurementNumber;
    }

    @Override
    public AbsoluteDate getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public EstimatedMeasurement<?> getPredictedMeasurement() {
        return this.predictedMeasurement;
    }

    @Override
    public EstimatedMeasurement<?> getCorrectedMeasurement() {
        return this.correctedMeasurement;
    }

    @Override
    public void updateNominalSpacecraftState(SpacecraftState nominal) {
        this.nominalMeanSpacecraftState = nominal;
        this.shortPeriodicTerms = new ArrayRealVector(this.dsstPropagator.getShortPeriodTermsValue(this.nominalMeanSpacecraftState));
        this.builder.resetOrbit(nominal.getOrbit(), PropagationType.MEAN);
    }

    @Override
    public void updateShortPeriods(SpacecraftState state) {
        for (DSSTForceModel model : this.dsstPropagator.getAllForceModels()) {
            model.updateShortPeriodTerms(model.getParameters(), state);
        }
    }

    @Override
    public void initializeShortPeriodicTerms(SpacecraftState meanState) {
        ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
        for (DSSTForceModel force : this.builder.getAllForceModels()) {
            shortPeriodTerms.addAll(force.initializeShortPeriodTerms(new AuxiliaryElements(meanState.getOrbit(), 1), PropagationType.OSCULATING, force.getParameters()));
        }
        this.dsstPropagator.setShortPeriodTerms(shortPeriodTerms);
    }

    private RealVector computeOsculatingElements(RealVector filterCorrection, SpacecraftState meanState, RealVector shortPeriodTerms) {
        RealVector stateVector = this.toRealVector(meanState);
        return stateVector.add(filterCorrection).add(shortPeriodTerms);
    }

    private RealVector toRealVector(SpacecraftState state) {
        double[] stateArray = new double[6];
        this.orbitType.mapOrbitToArray(state.getOrbit(), this.angleType, stateArray, null);
        return new ArrayRealVector(stateArray);
    }

    public int getNumberSelectedOrbitalDrivers() {
        return this.estimatedOrbitalParameters.getNbParams();
    }

    public int getNumberSelectedPropagationDrivers() {
        return this.estimatedPropagationParameters.getNbParams();
    }

    public int getNumberSelectedMeasurementDrivers() {
        return this.estimatedMeasurementsParameters.getNbParams();
    }

    private void updateParameters() {
        RealVector correctedState = this.correctedEstimate.getState();
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            driver.setValue(driver.getValue() + correctedState.getEntry(i++));
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            driver.setValue(driver.getValue() + correctedState.getEntry(i++));
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            driver.setValue(driver.getValue() + correctedState.getEntry(i++));
        }
    }
}

