/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.QRDecomposer;
import org.hipparchus.util.UnscentedTransformProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.SemiAnalyticalUnscentedKalmanEstimator;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.utils.ParameterDriversList;

public class SemiAnalyticalUnscentedKalmanEstimatorBuilder {
    private MatrixDecomposer decomposer = new QRDecomposer(1.0E-15);
    private DSSTPropagatorBuilder propagatorBuilder = null;
    private ParameterDriversList estimatedMeasurementsParameters = new ParameterDriversList();
    private CovarianceMatrixProvider processNoiseMatrixProvider = null;
    private CovarianceMatrixProvider measurementProcessNoiseMatrix = null;
    private UnscentedTransformProvider utProvider = null;

    public SemiAnalyticalUnscentedKalmanEstimator build() {
        if (this.propagatorBuilder == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_PROPAGATOR_CONFIGURED, new Object[0]);
        }
        if (this.utProvider == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_UNSCENTED_TRANSFORM_CONFIGURED, new Object[0]);
        }
        return new SemiAnalyticalUnscentedKalmanEstimator(this.decomposer, this.propagatorBuilder, this.processNoiseMatrixProvider, this.estimatedMeasurementsParameters, this.measurementProcessNoiseMatrix, this.utProvider);
    }

    public SemiAnalyticalUnscentedKalmanEstimatorBuilder decomposer(MatrixDecomposer matrixDecomposer) {
        this.decomposer = matrixDecomposer;
        return this;
    }

    public SemiAnalyticalUnscentedKalmanEstimatorBuilder unscentedTransformProvider(UnscentedTransformProvider transformProvider) {
        this.utProvider = transformProvider;
        return this;
    }

    public SemiAnalyticalUnscentedKalmanEstimatorBuilder addPropagationConfiguration(DSSTPropagatorBuilder builder, CovarianceMatrixProvider provider) {
        this.propagatorBuilder = builder;
        this.processNoiseMatrixProvider = provider;
        return this;
    }

    public SemiAnalyticalUnscentedKalmanEstimatorBuilder estimatedMeasurementsParameters(ParameterDriversList estimatedMeasurementsParams, CovarianceMatrixProvider provider) {
        this.estimatedMeasurementsParameters = estimatedMeasurementsParams;
        this.measurementProcessNoiseMatrix = provider;
        return this;
    }
}

