/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.Collections;
import java.util.List;
import org.hipparchus.filtering.kalman.unscented.UnscentedKalmanFilter;
import org.hipparchus.filtering.kalman.unscented.UnscentedProcess;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.util.UnscentedTransformProvider;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.AbstractKalmanEstimator;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalUnscentedKalmanModel;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.utils.ParameterDriversList;

public class SemiAnalyticalUnscentedKalmanEstimator
extends AbstractKalmanEstimator {
    private final SemiAnalyticalUnscentedKalmanModel processModel;
    private final UnscentedKalmanFilter<MeasurementDecorator> filter;

    SemiAnalyticalUnscentedKalmanEstimator(MatrixDecomposer decomposer, DSSTPropagatorBuilder propagatorBuilder, CovarianceMatrixProvider processNoiseMatricesProvider, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix, UnscentedTransformProvider utProvider) {
        super(Collections.singletonList(propagatorBuilder));
        this.processModel = new SemiAnalyticalUnscentedKalmanModel(propagatorBuilder, processNoiseMatricesProvider, estimatedMeasurementParameters, measurementProcessNoiseMatrix);
        this.filter = new UnscentedKalmanFilter(decomposer, (UnscentedProcess)this.processModel, this.processModel.getEstimate(), utProvider);
    }

    @Override
    protected KalmanEstimation getKalmanEstimation() {
        return this.processModel;
    }

    public void setObserver(KalmanObserver observer) {
        this.processModel.setObserver(observer);
    }

    public DSSTPropagator processMeasurements(List<ObservedMeasurement<?>> observedMeasurements) {
        return this.processModel.processMeasurements(observedMeasurements, this.filter);
    }
}

