/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.KalmanFilter;
import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.KalmanEstimatorUtil;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalProcess;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class SemiAnalyticalMeasurementHandler
implements OrekitStepHandler {
    private int index;
    private AbsoluteDate referenceDate;
    private final SemiAnalyticalProcess model;
    private final KalmanFilter<MeasurementDecorator> filter;
    private final List<ObservedMeasurement<?>> observedMeasurements;
    private final boolean isUnscented;

    public SemiAnalyticalMeasurementHandler(SemiAnalyticalProcess model, KalmanFilter<MeasurementDecorator> filter, List<ObservedMeasurement<?>> observedMeasurements, AbsoluteDate referenceDate) {
        this(model, filter, observedMeasurements, referenceDate, false);
    }

    public SemiAnalyticalMeasurementHandler(SemiAnalyticalProcess model, KalmanFilter<MeasurementDecorator> filter, List<ObservedMeasurement<?>> observedMeasurements, AbsoluteDate referenceDate, boolean isUnscented) {
        this.model = model;
        this.filter = filter;
        this.observedMeasurements = observedMeasurements;
        this.referenceDate = referenceDate;
        this.isUnscented = isUnscented;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.index = 0;
        this.model.initializeShortPeriodicTerms(s0);
        this.model.updateShortPeriods(s0);
    }

    @Override
    public void handleStep(OrekitStepInterpolator interpolator) {
        AbsoluteDate currentDate = interpolator.getCurrentState().getDate();
        this.model.updateShortPeriods(interpolator.getCurrentState());
        while (this.index < this.observedMeasurements.size() && this.observedMeasurements.get(this.index).getDate().compareTo(currentDate) < 0) {
            try {
                this.model.updateNominalSpacecraftState(interpolator.getInterpolatedState(this.observedMeasurements.get(this.index).getDate()));
                MeasurementDecorator decorated = this.isUnscented ? KalmanEstimatorUtil.decorateUnscented(this.observedMeasurements.get(this.index), this.referenceDate) : KalmanEstimatorUtil.decorate(this.observedMeasurements.get(this.index), this.referenceDate);
                ProcessEstimate estimate = this.filter.estimationStep((Measurement)decorated);
                this.model.finalizeEstimation(this.observedMeasurements.get(this.index), estimate);
            }
            catch (MathRuntimeException mrte) {
                throw new OrekitException(mrte);
            }
            ++this.index;
        }
        this.model.finalizeOperationsObservationGrid();
    }
}

