/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.KalmanFilter;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.extended.ExtendedKalmanFilter;
import org.hipparchus.filtering.kalman.extended.NonLinearEvolution;
import org.hipparchus.filtering.kalman.extended.NonLinearProcess;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanEstimatorUtil;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalKalmanEstimator;
import org.orekit.estimation.sequential.SemiAnalyticalMeasurementHandler;
import org.orekit.estimation.sequential.SemiAnalyticalProcess;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTHarvester;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeSpanMap;

public class SemiAnalyticalKalmanModel
implements KalmanEstimation,
NonLinearProcess<MeasurementDecorator>,
SemiAnalyticalProcess {
    private final DSSTPropagatorBuilder builder;
    private final ParameterDriversList estimatedOrbitalParameters;
    private final ParameterDriversList estimatedPropagationParameters;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final Map<String, Integer> propagationParameterColumns;
    private final Map<String, Integer> measurementParameterColumns;
    private final double[] scale;
    private final CovarianceMatrixProvider covarianceMatrixProvider;
    private final CovarianceMatrixProvider measurementProcessNoiseMatrix;
    private DSSTHarvester harvester;
    private DSSTPropagator dsstPropagator;
    private KalmanObserver observer;
    private int currentMeasurementNumber;
    private AbsoluteDate currentDate;
    private RealVector predictedFilterCorrection;
    private RealVector correctedFilterCorrection;
    private EstimatedMeasurement<?> predictedMeasurement;
    private EstimatedMeasurement<?> correctedMeasurement;
    private SpacecraftState nominalMeanSpacecraftState;
    private SpacecraftState previousNominalMeanSpacecraftState;
    private ProcessEstimate correctedEstimate;
    private RealMatrix phiS;
    private RealMatrix psiS;

    /*
     * WARNING - void declaration
     */
    protected SemiAnalyticalKalmanModel(DSSTPropagatorBuilder propagatorBuilder, CovarianceMatrixProvider covarianceMatrixProvider, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        TimeSpanMap.Span<String> span;
        this.builder = propagatorBuilder;
        this.estimatedMeasurementsParameters = estimatedMeasurementParameters;
        this.measurementParameterColumns = new HashMap<String, Integer>(this.estimatedMeasurementsParameters.getDrivers().size());
        this.observer = null;
        this.currentMeasurementNumber = 0;
        this.currentDate = propagatorBuilder.getInitialOrbitDate();
        this.covarianceMatrixProvider = covarianceMatrixProvider;
        this.measurementProcessNoiseMatrix = measurementProcessNoiseMatrix;
        int columns = 0;
        this.estimatedOrbitalParameters = new ParameterDriversList();
        for (ParameterDriver parameterDriver : this.builder.getOrbitalParametersDrivers().getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            if (!parameterDriver.isSelected()) continue;
            this.estimatedOrbitalParameters.add(parameterDriver);
            ++columns;
        }
        this.estimatedPropagationParameters = new ParameterDriversList();
        ArrayList<String> estimatedPropagationParametersNames = new ArrayList<String>();
        for (ParameterDriver parameterDriver : this.builder.getPropagationParametersDrivers().getDrivers()) {
            void var9_24;
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            if (!parameterDriver.isSelected()) continue;
            this.estimatedPropagationParameters.add(parameterDriver);
            TimeSpanMap.Span<String> span2 = parameterDriver.getNamesSpanMap().getFirstSpan();
            while (var9_24 != null) {
                if (!estimatedPropagationParametersNames.contains(var9_24.getData())) {
                    estimatedPropagationParametersNames.add((String)var9_24.getData());
                }
                TimeSpanMap.Span span3 = var9_24.next();
            }
        }
        estimatedPropagationParametersNames.sort(Comparator.naturalOrder());
        this.propagationParameterColumns = new HashMap<String, Integer>(estimatedPropagationParametersNames.size());
        for (String string : estimatedPropagationParametersNames) {
            this.propagationParameterColumns.put(string, columns);
            ++columns;
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            void var9_29;
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            TimeSpanMap.Span<String> span4 = parameterDriver.getNamesSpanMap().getFirstSpan();
            while (var9_29 != null) {
                this.measurementParameterColumns.put((String)var9_29.getData(), columns);
                ++columns;
                TimeSpanMap.Span span5 = var9_29.next();
            }
        }
        this.scale = new double[columns];
        boolean bl = false;
        for (ParameterDriver parameterDriver : this.estimatedOrbitalParameters.getDrivers()) {
            this.scale[++var7_12] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.estimatedPropagationParameters.getDrivers()) {
            for (span = parameterDriver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                this.scale[++var7_13] = parameterDriver.getScale();
            }
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            for (span = parameterDriver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                this.scale[++var7_14] = parameterDriver.getScale();
            }
        }
        this.updateReferenceTrajectory(this.getEstimatedPropagator());
        this.previousNominalMeanSpacecraftState = this.nominalMeanSpacecraftState = this.dsstPropagator.getInitialState();
        this.harvester.initializeFieldShortPeriodTerms(this.nominalMeanSpacecraftState);
        this.correctedFilterCorrection = this.predictedFilterCorrection = MatrixUtils.createRealVector((int)columns);
        this.psiS = null;
        if (this.estimatedPropagationParameters.getNbParams() != 0) {
            this.psiS = MatrixUtils.createRealMatrix((int)this.getNumberSelectedOrbitalDriversValuesToEstimate(), (int)this.getNumberSelectedPropagationDriversValuesToEstimate());
        }
        this.phiS = MatrixUtils.createRealIdentityMatrix((int)this.getNumberSelectedOrbitalDriversValuesToEstimate());
        int n = this.getNumberSelectedMeasurementDriversValuesToEstimate();
        int n2 = this.getNumberSelectedOrbitalDriversValuesToEstimate() + this.getNumberSelectedPropagationDriversValuesToEstimate();
        RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(n2 + n), (int)(n2 + n));
        RealMatrix noiseP = covarianceMatrixProvider.getInitialCovarianceMatrix(this.nominalMeanSpacecraftState);
        noiseK.setSubMatrix(noiseP.getData(), 0, 0);
        if (measurementProcessNoiseMatrix != null) {
            RealMatrix noiseM = measurementProcessNoiseMatrix.getInitialCovarianceMatrix(this.nominalMeanSpacecraftState);
            noiseK.setSubMatrix(noiseM.getData(), n2, n2);
        }
        KalmanEstimatorUtil.checkDimension(noiseK.getRowDimension(), this.builder.getOrbitalParametersDrivers(), this.builder.getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
        RealMatrix correctedCovariance = KalmanEstimatorUtil.normalizeCovarianceMatrix(noiseK, this.scale);
        this.correctedEstimate = new ProcessEstimate(0.0, this.correctedFilterCorrection, correctedCovariance);
    }

    @Override
    public KalmanObserver getObserver() {
        return this.observer;
    }

    public void setObserver(KalmanObserver observer) {
        this.observer = observer;
    }

    public ProcessEstimate getEstimate() {
        return this.correctedEstimate;
    }

    public DSSTPropagator processMeasurements(List<ObservedMeasurement<?>> observedMeasurements, ExtendedKalmanFilter<MeasurementDecorator> filter) {
        try {
            observedMeasurements.sort(new ChronologicalComparator());
            AbsoluteDate tStart = observedMeasurements.get(0).getDate();
            AbsoluteDate tEnd = observedMeasurements.get(observedMeasurements.size() - 1).getDate();
            double overshootTimeRange = FastMath.nextAfter((double)tEnd.durationFrom(tStart), (double)Double.POSITIVE_INFINITY);
            SemiAnalyticalMeasurementHandler stepHandler = new SemiAnalyticalMeasurementHandler(this, (KalmanFilter<MeasurementDecorator>)filter, observedMeasurements, this.builder.getInitialOrbitDate());
            this.dsstPropagator.getMultiplexer().add(stepHandler);
            this.dsstPropagator.propagate(tStart, tStart.shiftedBy(overshootTimeRange));
            return this.getEstimatedPropagator();
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public DSSTPropagator getEstimatedPropagator() {
        return (DSSTPropagator)this.builder.buildPropagator();
    }

    public NonLinearEvolution getEvolution(double previousTime, RealVector previousState, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (driver.getReferenceDate() != null) continue;
            driver.setReferenceDate(this.builder.getInitialOrbitDate());
        }
        ++this.currentMeasurementNumber;
        this.currentDate = measurement.getObservedMeasurement().getDate();
        RealMatrix stm = this.getErrorStateTransitionMatrix();
        this.predictedFilterCorrection = this.predictFilterCorrection(stm);
        this.analyticalDerivativeComputations(this.nominalMeanSpacecraftState);
        double[] osculating = this.computeOsculatingElements(this.predictedFilterCorrection);
        Orbit osculatingOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(osculating, null, this.builder.getPositionAngleType(), this.currentDate, this.nominalMeanSpacecraftState.getMu(), this.nominalMeanSpacecraftState.getFrame());
        this.predictedMeasurement = observedMeasurement.estimate(this.currentMeasurementNumber, this.currentMeasurementNumber, new SpacecraftState[]{new SpacecraftState(osculatingOrbit, this.nominalMeanSpacecraftState.getAttitude(), this.nominalMeanSpacecraftState.getMass(), this.nominalMeanSpacecraftState.getAdditionalStatesValues(), this.nominalMeanSpacecraftState.getAdditionalStatesDerivatives())});
        RealMatrix measurementMatrix = this.getMeasurementMatrix();
        int nbMeas = this.getNumberSelectedMeasurementDriversValuesToEstimate();
        int nbDyn = this.getNumberSelectedOrbitalDriversValuesToEstimate() + this.getNumberSelectedPropagationDriversValuesToEstimate();
        RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(nbDyn + nbMeas), (int)(nbDyn + nbMeas));
        RealMatrix noiseP = this.covarianceMatrixProvider.getProcessNoiseMatrix(this.previousNominalMeanSpacecraftState, this.nominalMeanSpacecraftState);
        noiseK.setSubMatrix(noiseP.getData(), 0, 0);
        if (this.measurementProcessNoiseMatrix != null) {
            RealMatrix noiseM = this.measurementProcessNoiseMatrix.getProcessNoiseMatrix(this.previousNominalMeanSpacecraftState, this.nominalMeanSpacecraftState);
            noiseK.setSubMatrix(noiseM.getData(), nbDyn, nbDyn);
        }
        KalmanEstimatorUtil.checkDimension(noiseK.getRowDimension(), this.builder.getOrbitalParametersDrivers(), this.builder.getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
        RealMatrix normalizedProcessNoise = KalmanEstimatorUtil.normalizeCovarianceMatrix(noiseK, this.scale);
        return new NonLinearEvolution(measurement.getTime(), this.predictedFilterCorrection, stm, normalizedProcessNoise, measurementMatrix);
    }

    public RealVector getInnovation(MeasurementDecorator measurement, NonLinearEvolution evolution, RealMatrix innovationCovarianceMatrix) {
        KalmanEstimatorUtil.applyDynamicOutlierFilter(this.predictedMeasurement, innovationCovarianceMatrix);
        return KalmanEstimatorUtil.computeInnovationVector(this.predictedMeasurement, this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    @Override
    public void finalizeEstimation(ObservedMeasurement<?> observedMeasurement, ProcessEstimate estimate) {
        this.correctedEstimate = estimate;
        this.correctedFilterCorrection = estimate.getState();
        this.previousNominalMeanSpacecraftState = this.nominalMeanSpacecraftState;
        double[] osculating = this.computeOsculatingElements(this.correctedFilterCorrection);
        Orbit osculatingOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(osculating, null, this.builder.getPositionAngleType(), this.currentDate, this.nominalMeanSpacecraftState.getMu(), this.nominalMeanSpacecraftState.getFrame());
        this.correctedMeasurement = observedMeasurement.estimate(this.currentMeasurementNumber, this.currentMeasurementNumber, new SpacecraftState[]{new SpacecraftState(osculatingOrbit, this.nominalMeanSpacecraftState.getAttitude(), this.nominalMeanSpacecraftState.getMass(), this.nominalMeanSpacecraftState.getAdditionalStatesValues(), this.nominalMeanSpacecraftState.getAdditionalStatesDerivatives())});
        if (this.observer != null) {
            this.observer.evaluationPerformed(this);
        }
    }

    @Override
    public void finalizeOperationsObservationGrid() {
        this.updateParameters();
    }

    @Override
    public ParameterDriversList getEstimatedOrbitalParameters() {
        return this.estimatedOrbitalParameters;
    }

    @Override
    public ParameterDriversList getEstimatedPropagationParameters() {
        return this.estimatedPropagationParameters;
    }

    @Override
    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.estimatedMeasurementsParameters;
    }

    @Override
    public SpacecraftState[] getPredictedSpacecraftStates() {
        return new SpacecraftState[]{this.nominalMeanSpacecraftState};
    }

    @Override
    public SpacecraftState[] getCorrectedSpacecraftStates() {
        return new SpacecraftState[]{this.getEstimatedPropagator().getInitialState()};
    }

    @Override
    public RealVector getPhysicalEstimatedState() {
        TimeSpanMap.Span<Double> span;
        ArrayRealVector physicalEstimatedState = new ArrayRealVector(this.scale.length);
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            for (span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                physicalEstimatedState.setEntry(i++, span.getData().doubleValue());
            }
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            for (span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                physicalEstimatedState.setEntry(i++, span.getData().doubleValue());
            }
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            for (span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                physicalEstimatedState.setEntry(i++, span.getData().doubleValue());
            }
        }
        return physicalEstimatedState;
    }

    @Override
    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        return KalmanEstimatorUtil.unnormalizeCovarianceMatrix(this.correctedEstimate.getCovariance(), this.scale);
    }

    @Override
    public RealMatrix getPhysicalStateTransitionMatrix() {
        return this.correctedEstimate.getStateTransitionMatrix() == null ? null : KalmanEstimatorUtil.unnormalizeStateTransitionMatrix(this.correctedEstimate.getStateTransitionMatrix(), this.scale);
    }

    @Override
    public RealMatrix getPhysicalMeasurementJacobian() {
        return this.correctedEstimate.getMeasurementJacobian() == null ? null : KalmanEstimatorUtil.unnormalizeMeasurementJacobian(this.correctedEstimate.getMeasurementJacobian(), this.scale, this.correctedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    @Override
    public RealMatrix getPhysicalInnovationCovarianceMatrix() {
        return this.correctedEstimate.getInnovationCovariance() == null ? null : KalmanEstimatorUtil.unnormalizeInnovationCovarianceMatrix(this.correctedEstimate.getInnovationCovariance(), this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    @Override
    public RealMatrix getPhysicalKalmanGain() {
        return this.correctedEstimate.getKalmanGain() == null ? null : KalmanEstimatorUtil.unnormalizeKalmanGainMatrix(this.correctedEstimate.getKalmanGain(), this.scale, this.correctedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    @Override
    public int getCurrentMeasurementNumber() {
        return this.currentMeasurementNumber;
    }

    @Override
    public AbsoluteDate getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public EstimatedMeasurement<?> getPredictedMeasurement() {
        return this.predictedMeasurement;
    }

    @Override
    public EstimatedMeasurement<?> getCorrectedMeasurement() {
        return this.correctedMeasurement;
    }

    @Override
    public void updateNominalSpacecraftState(SpacecraftState nominal) {
        this.nominalMeanSpacecraftState = nominal;
        this.builder.resetOrbit(nominal.getOrbit(), PropagationType.MEAN);
        this.builder.setMass(nominal.getMass());
    }

    public void updateReferenceTrajectory(DSSTPropagator propagator) {
        this.dsstPropagator = propagator;
        String equationName = SemiAnalyticalKalmanEstimator.class.getName() + "-derivatives-";
        SpacecraftState meanState = this.dsstPropagator.initialIsOsculating() ? DSSTPropagator.computeMeanState(this.dsstPropagator.getInitialState(), this.dsstPropagator.getAttitudeProvider(), this.dsstPropagator.getAllForceModels()) : this.dsstPropagator.getInitialState();
        this.dsstPropagator.setInitialState(meanState, PropagationType.MEAN);
        this.harvester = this.dsstPropagator.setupMatricesComputation(equationName, null, null);
    }

    @Override
    public void updateShortPeriods(SpacecraftState state) {
        for (DSSTForceModel model : this.builder.getAllForceModels()) {
            model.updateShortPeriodTerms(model.getParametersAllValues(), state);
        }
        this.harvester.updateFieldShortPeriodTerms(state);
    }

    @Override
    public void initializeShortPeriodicTerms(SpacecraftState meanState) {
        ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
        PropagationType type = PropagationType.OSCULATING;
        for (DSSTForceModel force : this.builder.getAllForceModels()) {
            shortPeriodTerms.addAll(force.initializeShortPeriodTerms(new AuxiliaryElements(meanState.getOrbit(), 1), type, force.getParameters(meanState.getDate())));
        }
        this.dsstPropagator.setShortPeriodTerms(shortPeriodTerms);
        this.harvester.initializeFieldShortPeriodTerms(meanState, type);
    }

    private RealMatrix getErrorStateTransitionMatrix() {
        int i;
        RealMatrix stm = MatrixUtils.createRealIdentityMatrix((int)this.correctedEstimate.getState().getDimension());
        int nbOrb = this.getNumberSelectedOrbitalDriversValuesToEstimate();
        RealMatrix dYdY0 = this.harvester.getB2(this.nominalMeanSpacecraftState);
        RealMatrix phi = dYdY0.multiply(this.phiS);
        List<ParameterDriversList.DelegatingDriver> drivers = this.builder.getOrbitalParametersDrivers().getDrivers();
        for (i = 0; i < nbOrb; ++i) {
            if (!drivers.get(i).isSelected()) continue;
            int jOrb = 0;
            for (int j = 0; j < nbOrb; ++j) {
                if (!drivers.get(j).isSelected()) continue;
                stm.setEntry(i, jOrb++, phi.getEntry(i, j));
            }
        }
        this.phiS = new QRDecomposition(dYdY0).getSolver().getInverse();
        if (this.psiS != null) {
            int nbProp = this.getNumberSelectedPropagationDriversValuesToEstimate();
            RealMatrix dYdPp = this.harvester.getB3(this.nominalMeanSpacecraftState);
            RealMatrix psi = dYdPp.subtract(phi.multiply(this.psiS));
            for (int i2 = 0; i2 < nbOrb; ++i2) {
                for (int j = 0; j < nbProp; ++j) {
                    stm.setEntry(i2, j + nbOrb, psi.getEntry(i2, j));
                }
            }
            this.psiS = dYdPp;
        }
        for (i = 0; i < this.scale.length; ++i) {
            for (int j = 0; j < this.scale.length; ++j) {
                stm.setEntry(i, j, stm.getEntry(i, j) * this.scale[j] / this.scale[i]);
            }
        }
        return stm;
    }

    private RealMatrix getMeasurementMatrix() {
        SpacecraftState evaluationState = this.predictedMeasurement.getStates()[0];
        Object observedMeasurement = this.predictedMeasurement.getObservedMeasurement();
        double[] sigma = this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        RealMatrix measurementMatrix = MatrixUtils.createRealMatrix((int)observedMeasurement.getDimension(), (int)this.correctedEstimate.getState().getDimension());
        Orbit predictedOrbit = evaluationState.getOrbit();
        int nbOrb = this.getNumberSelectedOrbitalDrivers();
        int nbProp = this.getNumberSelectedPropagationDrivers();
        double[][] aCY = new double[nbOrb][nbOrb];
        predictedOrbit.getJacobianWrtParameters(this.builder.getPositionAngleType(), aCY);
        Array2DRowRealMatrix dCdY = new Array2DRowRealMatrix(aCY, false);
        Array2DRowRealMatrix dMdC = new Array2DRowRealMatrix(this.predictedMeasurement.getStateDerivatives(0), false);
        RealMatrix dMdY = dMdC.multiply((RealMatrix)dCdY);
        RealMatrix IpB1B4 = MatrixUtils.createRealMatrix((int)nbOrb, (int)(nbOrb + nbProp));
        RealMatrix B1 = this.harvester.getB1();
        RealMatrix I = MatrixUtils.createRealIdentityMatrix((int)nbOrb);
        RealMatrix IpB1 = I.add(B1);
        IpB1B4.setSubMatrix(IpB1.getData(), 0, 0);
        if (this.psiS != null) {
            RealMatrix B4 = this.harvester.getB4();
            IpB1B4.setSubMatrix(B4.getData(), 0, nbOrb);
        }
        dMdY = dMdY.multiply(IpB1B4);
        for (int i = 0; i < dMdY.getRowDimension(); ++i) {
            for (int j = 0; j < nbOrb; ++j) {
                double driverScale = this.builder.getOrbitalParametersDrivers().getDrivers().get(j).getScale();
                measurementMatrix.setEntry(i, j, dMdY.getEntry(i, j) / sigma[i] * driverScale);
            }
            int col = 0;
            for (int j = 0; j < nbProp; ++j) {
                double driverScale = this.estimatedPropagationParameters.getDrivers().get(j).getScale();
                for (TimeSpanMap.Span<Double> span = this.estimatedPropagationParameters.getDrivers().get(j).getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                    measurementMatrix.setEntry(i, col + nbOrb, dMdY.getEntry(i, col + nbOrb) / sigma[i] * driverScale);
                    ++col;
                }
            }
        }
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                double[] aMPm = this.predictedMeasurement.getParameterDerivatives(driver, span.getStart());
                if (this.measurementParameterColumns.get(span.getData()) == null) continue;
                int driverColumn = this.measurementParameterColumns.get(span.getData());
                for (int i = 0; i < aMPm.length; ++i) {
                    measurementMatrix.setEntry(i, driverColumn, aMPm[i] / sigma[i] * driver.getScale());
                }
            }
        }
        return measurementMatrix;
    }

    private RealVector predictFilterCorrection(RealMatrix stm) {
        return stm.operate(this.correctedFilterCorrection);
    }

    private double[] computeOsculatingElements(RealVector filterCorrection) {
        int nbOrb = this.getNumberSelectedOrbitalDrivers();
        RealMatrix B1 = this.harvester.getB1();
        double[] shortPeriodTerms = this.dsstPropagator.getShortPeriodTermsValue(this.nominalMeanSpacecraftState);
        RealVector physicalFilterCorrection = MatrixUtils.createRealVector((int)nbOrb);
        for (int index = 0; index < nbOrb; ++index) {
            physicalFilterCorrection.addToEntry(index, filterCorrection.getEntry(index) * this.scale[index]);
        }
        RealVector B1Correction = B1.operate(physicalFilterCorrection);
        double[] nominalMeanElements = new double[nbOrb];
        OrbitType.EQUINOCTIAL.mapOrbitToArray(this.nominalMeanSpacecraftState.getOrbit(), this.builder.getPositionAngleType(), nominalMeanElements, null);
        double[] osculatingElements = new double[nbOrb];
        for (int i = 0; i < nbOrb; ++i) {
            osculatingElements[i] = nominalMeanElements[i] + physicalFilterCorrection.getEntry(i) + shortPeriodTerms[i] + B1Correction.getEntry(i);
        }
        return osculatingElements;
    }

    private void analyticalDerivativeComputations(SpacecraftState state) {
        this.harvester.setReferenceState(state);
    }

    private int getNumberSelectedOrbitalDrivers() {
        return this.estimatedOrbitalParameters.getNbParams();
    }

    private int getNumberSelectedPropagationDrivers() {
        return this.estimatedPropagationParameters.getNbParams();
    }

    private int getNumberSelectedOrbitalDriversValuesToEstimate() {
        int nbOrbitalValuesToEstimate = 0;
        for (ParameterDriver parameterDriver : this.estimatedOrbitalParameters.getDrivers()) {
            nbOrbitalValuesToEstimate += parameterDriver.getNbOfValues();
        }
        return nbOrbitalValuesToEstimate;
    }

    private int getNumberSelectedPropagationDriversValuesToEstimate() {
        int nbPropagationValuesToEstimate = 0;
        for (ParameterDriver parameterDriver : this.estimatedPropagationParameters.getDrivers()) {
            nbPropagationValuesToEstimate += parameterDriver.getNbOfValues();
        }
        return nbPropagationValuesToEstimate;
    }

    private int getNumberSelectedMeasurementDriversValuesToEstimate() {
        int nbMeasurementValuesToEstimate = 0;
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            nbMeasurementValuesToEstimate += parameterDriver.getNbOfValues();
        }
        return nbMeasurementValuesToEstimate;
    }

    private void updateParameters() {
        TimeSpanMap.Span<Double> span;
        RealVector correctedState = this.correctedEstimate.getState();
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            for (span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                driver.setNormalizedValue(driver.getNormalizedValue(span.getStart()) + correctedState.getEntry(i++), span.getStart());
            }
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            for (span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                driver.setNormalizedValue(driver.getNormalizedValue(span.getStart()) + correctedState.getEntry(i++), span.getStart());
            }
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            for (span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                driver.setNormalizedValue(driver.getNormalizedValue(span.getStart()) + correctedState.getEntry(i++), span.getStart());
            }
        }
    }
}

