/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.extended.ExtendedKalmanFilter;
import org.hipparchus.filtering.kalman.extended.NonLinearProcess;
import org.hipparchus.linear.MatrixDecomposer;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.AbstractKalmanEstimator;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalKalmanModel;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.utils.ParameterDriversList;

public class SemiAnalyticalKalmanEstimator
extends AbstractKalmanEstimator {
    private final SemiAnalyticalKalmanModel processModel;
    private final ExtendedKalmanFilter<MeasurementDecorator> filter;

    public SemiAnalyticalKalmanEstimator(MatrixDecomposer decomposer, DSSTPropagatorBuilder propagatorBuilder, CovarianceMatrixProvider covarianceMatrixProvider, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        super(Collections.singletonList(propagatorBuilder));
        this.processModel = new SemiAnalyticalKalmanModel(propagatorBuilder, covarianceMatrixProvider, estimatedMeasurementParameters, measurementProcessNoiseMatrix);
        this.filter = new ExtendedKalmanFilter(decomposer, (NonLinearProcess)this.processModel, this.processModel.getEstimate());
    }

    @Override
    protected KalmanEstimation getKalmanEstimation() {
        return this.processModel;
    }

    public void setObserver(KalmanObserver observer) {
        this.processModel.setObserver(observer);
    }

    public DSSTPropagator processMeasurements(List<ObservedMeasurement<?>> observedMeasurements) {
        try {
            return this.processModel.processMeasurements(observedMeasurements, this.filter);
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }
}

