/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import java.util.Map;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.extended.NonLinearEvolution;
import org.hipparchus.filtering.kalman.extended.NonLinearProcess;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimationCommon;
import org.orekit.estimation.sequential.KalmanEstimator;
import org.orekit.estimation.sequential.KalmanEstimatorUtil;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class KalmanModel
extends KalmanEstimationCommon
implements NonLinearProcess<MeasurementDecorator> {
    private MatricesHarvester[] harvesters;
    private Propagator[] referenceTrajectories;

    public KalmanModel(List<PropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        super(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementParameters, measurementProcessNoiseMatrix);
        this.updateReferenceTrajectories(this.getEstimatedPropagators());
    }

    protected void updateReferenceTrajectories(Propagator[] propagators) {
        this.setReferenceTrajectories(propagators);
        this.harvesters = new MatricesHarvester[propagators.length];
        for (int k = 0; k < propagators.length; ++k) {
            String equationName = KalmanEstimator.class.getName() + "-derivatives-" + k;
            this.harvesters[k] = this.getReferenceTrajectories()[k].setupMatricesComputation(equationName, null, null);
        }
    }

    private RealMatrix getErrorStateTransitionMatrix() {
        RealMatrix stm = MatrixUtils.createRealIdentityMatrix((int)this.getCorrectedEstimate().getState().getDimension());
        SpacecraftState[] predictedSpacecraftStates = this.getPredictedSpacecraftStates();
        int[][] covarianceIndirection = this.getCovarianceIndirection();
        ParameterDriversList[] estimatedOrbitalParameters = this.getEstimatedOrbitalParametersArray();
        ParameterDriversList[] estimatedPropagationParameters = this.getEstimatedPropagationParametersArray();
        double[] scale = this.getScale();
        for (int k = 0; k < predictedSpacecraftStates.length; ++k) {
            int j;
            List<ParameterDriversList.DelegatingDriver> orbitalParameterDrivers = ((PropagatorBuilder)this.getBuilders().get(k)).getOrbitalParametersDrivers().getDrivers();
            int[] indK = covarianceIndirection[k];
            int nbOrbParams = estimatedOrbitalParameters[k].getNbParams();
            if (nbOrbParams > 0) {
                this.harvesters[k].setReferenceState(predictedSpacecraftStates[k]);
                RealMatrix dYdY0 = this.harvesters[k].getStateTransitionMatrix(predictedSpacecraftStates[k]);
                int stmRow = 0;
                for (int i = 0; i < dYdY0.getRowDimension(); ++i) {
                    int stmCol = 0;
                    if (!orbitalParameterDrivers.get(i).isSelected()) continue;
                    for (j = 0; j < nbOrbParams; ++j) {
                        if (!orbitalParameterDrivers.get(j).isSelected()) continue;
                        stm.setEntry(indK[stmRow], indK[stmCol], dYdY0.getEntry(i, j));
                        ++stmCol;
                    }
                    ++stmRow;
                }
            }
            int nbParams = estimatedPropagationParameters[k].getNbParams();
            if (nbOrbParams <= 0 || nbParams <= 0) continue;
            RealMatrix dYdPp = this.harvesters[k].getParametersJacobian(predictedSpacecraftStates[k]);
            int stmRow = 0;
            for (int i = 0; i < dYdPp.getRowDimension(); ++i) {
                if (!orbitalParameterDrivers.get(i).isSelected()) continue;
                for (j = 0; j < nbParams; ++j) {
                    stm.setEntry(indK[stmRow], indK[j + nbOrbParams], dYdPp.getEntry(i, j));
                }
                ++stmRow;
            }
        }
        for (int i = 0; i < scale.length; ++i) {
            for (int j = 0; j < scale.length; ++j) {
                stm.setEntry(i, j, stm.getEntry(i, j) * scale[j] / scale[i]);
            }
        }
        return stm;
    }

    private RealMatrix getMeasurementMatrix() {
        EstimatedMeasurement predictedMeasurement = this.getPredictedMeasurement();
        SpacecraftState[] evaluationStates = predictedMeasurement.getStates();
        Object observedMeasurement = predictedMeasurement.getObservedMeasurement();
        double[] sigma = observedMeasurement.getTheoreticalStandardDeviation();
        RealMatrix measurementMatrix = MatrixUtils.createRealMatrix((int)observedMeasurement.getDimension(), (int)this.getCorrectedEstimate().getState().getDimension());
        int[] orbitsStartColumns = this.getOrbitsStartColumns();
        ParameterDriversList[] estimatedPropagationParameters = this.getEstimatedPropagationParametersArray();
        Map<String, Integer> propagationParameterColumns = this.getPropagationParameterColumns();
        Map<String, Integer> measurementParameterColumns = this.getMeasurementParameterColumns();
        for (int k = 0; k < evaluationStates.length; ++k) {
            int p = observedMeasurement.getSatellites().get(k).getPropagatorIndex();
            Orbit predictedOrbit = evaluationStates[k].getOrbit();
            double[][] aCY = new double[6][6];
            predictedOrbit.getJacobianWrtParameters(((PropagatorBuilder)this.getBuilders().get(p)).getPositionAngleType(), aCY);
            Array2DRowRealMatrix dCdY = new Array2DRowRealMatrix(aCY, false);
            Array2DRowRealMatrix dMdC = new Array2DRowRealMatrix(predictedMeasurement.getStateDerivatives(k), false);
            RealMatrix dMdY = dMdC.multiply((RealMatrix)dCdY);
            for (int i = 0; i < dMdY.getRowDimension(); ++i) {
                int jOrb = orbitsStartColumns[p];
                for (int j = 0; j < dMdY.getColumnDimension(); ++j) {
                    ParameterDriver driver = ((PropagatorBuilder)this.getBuilders().get(p)).getOrbitalParametersDrivers().getDrivers().get(j);
                    if (!driver.isSelected()) continue;
                    measurementMatrix.setEntry(i, jOrb++, dMdY.getEntry(i, j) / sigma[i] * driver.getScale());
                }
            }
            int nbParams = estimatedPropagationParameters[p].getNbParams();
            if (nbParams > 0) {
                RealMatrix dYdPp = this.harvesters[p].getParametersJacobian(evaluationStates[k]);
                RealMatrix dMdPp = dMdY.multiply(dYdPp);
                for (int i = 0; i < dMdPp.getRowDimension(); ++i) {
                    for (int j = 0; j < nbParams; ++j) {
                        ParameterDriver delegating = estimatedPropagationParameters[p].getDrivers().get(j);
                        measurementMatrix.setEntry(i, propagationParameterColumns.get(delegating.getName()).intValue(), dMdPp.getEntry(i, j) / sigma[i] * delegating.getScale());
                    }
                }
            }
            for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                double[] aMPm = predictedMeasurement.getParameterDerivatives(driver);
                if (measurementParameterColumns.get(driver.getName()) == null) continue;
                int driverColumn = measurementParameterColumns.get(driver.getName());
                for (int i = 0; i < aMPm.length; ++i) {
                    measurementMatrix.setEntry(i, driverColumn, aMPm[i] / sigma[i] * driver.getScale());
                }
            }
        }
        return measurementMatrix;
    }

    public NonLinearEvolution getEvolution(double previousTime, RealVector previousState, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (driver.getReferenceDate() != null) continue;
            driver.setReferenceDate(((PropagatorBuilder)this.getBuilders().get(0)).getInitialOrbitDate());
        }
        this.incrementCurrentMeasurementNumber();
        this.setCurrentDate(measurement.getObservedMeasurement().getDate());
        RealVector predictedState = this.predictState(observedMeasurement.getDate());
        RealMatrix stateTransitionMatrix = this.getErrorStateTransitionMatrix();
        this.setPredictedMeasurement(observedMeasurement.estimate(this.getCurrentMeasurementNumber(), this.getCurrentMeasurementNumber(), KalmanEstimatorUtil.filterRelevant(observedMeasurement, this.getPredictedSpacecraftStates())));
        RealMatrix measurementMatrix = this.getMeasurementMatrix();
        RealMatrix normalizedProcessNoise = this.getNormalizedProcessNoise(previousState.getDimension());
        return new NonLinearEvolution(measurement.getTime(), predictedState, stateTransitionMatrix, normalizedProcessNoise, measurementMatrix);
    }

    public RealVector getInnovation(MeasurementDecorator measurement, NonLinearEvolution evolution, RealMatrix innovationCovarianceMatrix) {
        EstimatedMeasurement predictedMeasurement = this.getPredictedMeasurement();
        KalmanEstimatorUtil.applyDynamicOutlierFilter(predictedMeasurement, innovationCovarianceMatrix);
        return KalmanEstimatorUtil.computeInnovationVector(predictedMeasurement, predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    public void finalizeEstimation(ObservedMeasurement<?> observedMeasurement, ProcessEstimate estimate) {
        this.setCorrectedEstimate(estimate);
        this.updateParameters();
        Propagator[] estimatedPropagators = this.getEstimatedPropagators();
        for (int k = 0; k < estimatedPropagators.length; ++k) {
            this.setCorrectedSpacecraftState(estimatedPropagators[k].getInitialState(), k);
        }
        this.setCorrectedMeasurement(observedMeasurement.estimate(this.getCurrentMeasurementNumber(), this.getCurrentMeasurementNumber(), KalmanEstimatorUtil.filterRelevant(observedMeasurement, this.getCorrectedSpacecraftStates())));
        this.updateReferenceTrajectories(estimatedPropagators);
    }

    private RealVector predictState(AbsoluteDate date) {
        RealVector predictedState = this.getCorrectedEstimate().getState().copy();
        int jOrb = 0;
        for (int k = 0; k < this.getPredictedSpacecraftStates().length; ++k) {
            SpacecraftState predictedSpacecraftState = this.referenceTrajectories[k].propagate(date);
            this.setPredictedSpacecraftState(predictedSpacecraftState, k);
            ((PropagatorBuilder)this.getBuilders().get(k)).resetOrbit(predictedSpacecraftState.getOrbit());
            if (this.getBuilders().get(k) instanceof AbstractPropagatorBuilder) {
                ((AbstractPropagatorBuilder)this.getBuilders().get(k)).setMass(predictedSpacecraftState.getMass());
            }
            for (ParameterDriversList.DelegatingDriver orbitalDriver : ((PropagatorBuilder)this.getBuilders().get(k)).getOrbitalParametersDrivers().getDrivers()) {
                if (!orbitalDriver.isSelected()) continue;
                predictedState.setEntry(jOrb++, orbitalDriver.getNormalizedValue());
            }
        }
        return predictedState;
    }

    private void updateParameters() {
        RealVector correctedState = this.getCorrectedEstimate().getState();
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            driver.setNormalizedValue(correctedState.getEntry(i));
            correctedState.setEntry(i++, driver.getNormalizedValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            driver.setNormalizedValue(correctedState.getEntry(i));
            correctedState.setEntry(i++, driver.getNormalizedValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            driver.setNormalizedValue(correctedState.getEntry(i));
            correctedState.setEntry(i++, driver.getNormalizedValue());
        }
    }

    public Propagator[] getReferenceTrajectories() {
        return (Propagator[])this.referenceTrajectories.clone();
    }

    public void setReferenceTrajectories(Propagator[] referenceTrajectories) {
        this.referenceTrajectories = (Propagator[])referenceTrajectories.clone();
    }
}

