/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.PV;
import org.orekit.estimation.measurements.Position;
import org.orekit.estimation.measurements.modifiers.DynamicOutlierFilter;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class KalmanEstimatorUtil {
    private KalmanEstimatorUtil() {
    }

    public static MeasurementDecorator decorate(ObservedMeasurement<?> observedMeasurement, AbsoluteDate referenceDate) {
        RealMatrix covariance;
        if (observedMeasurement.getMeasurementType().equals("PV")) {
            PV pv = (PV)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])pv.getCorrelationCoefficientsMatrix());
        } else if (observedMeasurement.getMeasurementType().equals("Position")) {
            Position position = (Position)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])position.getCorrelationCoefficientsMatrix());
        } else {
            covariance = MatrixUtils.createRealIdentityMatrix((int)observedMeasurement.getDimension());
        }
        return new MeasurementDecorator(observedMeasurement, covariance, referenceDate);
    }

    public static MeasurementDecorator decorateUnscented(ObservedMeasurement<?> observedMeasurement, AbsoluteDate referenceDate) {
        RealMatrix covariance;
        if (observedMeasurement.getMeasurementType().equals("PV")) {
            PV pv = (PV)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])pv.getCovarianceMatrix());
        } else if (observedMeasurement.getMeasurementType().equals("Position")) {
            Position position = (Position)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])position.getCovarianceMatrix());
        } else {
            covariance = MatrixUtils.createRealIdentityMatrix((int)observedMeasurement.getDimension());
            double[] sigma = observedMeasurement.getTheoreticalStandardDeviation();
            for (int i = 0; i < sigma.length; ++i) {
                covariance.setEntry(i, i, sigma[i] * sigma[i]);
            }
        }
        return new MeasurementDecorator(observedMeasurement, covariance, referenceDate);
    }

    public static void checkDimension(int dimension, ParameterDriversList orbitalParameters, ParameterDriversList propagationParameters, ParameterDriversList measurementParameters) {
        int requiredDimension = 0;
        for (ParameterDriver parameterDriver : orbitalParameters.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++requiredDimension;
        }
        for (ParameterDriver parameterDriver : propagationParameters.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++requiredDimension;
        }
        for (ParameterDriver parameterDriver : measurementParameters.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++requiredDimension;
        }
        if (dimension != requiredDimension) {
            StringBuilder sBuilder = new StringBuilder();
            for (ParameterDriver parameterDriver : orbitalParameters.getDrivers()) {
                if (sBuilder.length() > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(parameterDriver.getName());
            }
            for (ParameterDriver parameterDriver : propagationParameters.getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                sBuilder.append(parameterDriver.getName());
            }
            for (ParameterDriver parameterDriver : measurementParameters.getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                sBuilder.append(parameterDriver.getName());
            }
            throw new OrekitException((Localizable)OrekitMessages.DIMENSION_INCONSISTENT_WITH_PARAMETERS, dimension, sBuilder.toString());
        }
    }

    public static SpacecraftState[] filterRelevant(ObservedMeasurement<?> observedMeasurement, SpacecraftState[] allStates) {
        List<ObservableSatellite> satellites = observedMeasurement.getSatellites();
        SpacecraftState[] relevantStates = new SpacecraftState[satellites.size()];
        for (int i = 0; i < relevantStates.length; ++i) {
            relevantStates[i] = allStates[satellites.get(i).getPropagatorIndex()];
        }
        return relevantStates;
    }

    public static <T extends ObservedMeasurement<T>> void applyDynamicOutlierFilter(EstimatedMeasurement<T> measurement, RealMatrix innovationCovarianceMatrix) {
        Object observedMeasurement = measurement.getObservedMeasurement();
        for (EstimationModifier<T> modifier : observedMeasurement.getModifiers()) {
            if (!(modifier instanceof DynamicOutlierFilter)) continue;
            DynamicOutlierFilter dynamicOutlierFilter = (DynamicOutlierFilter)modifier;
            double[] sigmaDynamic = new double[innovationCovarianceMatrix.getColumnDimension()];
            double[] sigmaMeasurement = observedMeasurement.getTheoreticalStandardDeviation();
            for (int i = 0; i < sigmaDynamic.length; ++i) {
                sigmaDynamic[i] = FastMath.sqrt((double)innovationCovarianceMatrix.getEntry(i, i)) * sigmaMeasurement[i];
            }
            dynamicOutlierFilter.setSigma(sigmaDynamic);
            modifier.modify(measurement);
            dynamicOutlierFilter.setSigma(null);
        }
    }

    public static RealVector computeInnovationVector(EstimatedMeasurement<?> predicted) {
        double[] sigmas = new double[predicted.getObservedMeasurement().getDimension()];
        Arrays.fill(sigmas, 1.0);
        return KalmanEstimatorUtil.computeInnovationVector(predicted, sigmas);
    }

    public static RealVector computeInnovationVector(EstimatedMeasurement<?> predicted, double[] sigma) {
        if (predicted.getStatus() == EstimatedMeasurementBase.Status.REJECTED) {
            return null;
        }
        double[] observed = predicted.getObservedMeasurement().getObservedValue();
        double[] estimated = predicted.getEstimatedValue();
        double[] residuals = new double[observed.length];
        for (int i = 0; i < observed.length; ++i) {
            residuals[i] = (observed[i] - estimated[i]) / sigma[i];
        }
        return MatrixUtils.createRealVector((double[])residuals);
    }

    public static RealMatrix normalizeCovarianceMatrix(RealMatrix physicalP, double[] parameterScales) {
        int nbParams = physicalP.getRowDimension();
        RealMatrix normalizedP = MatrixUtils.createRealMatrix((int)nbParams, (int)nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                normalizedP.setEntry(i, j, physicalP.getEntry(i, j) / (parameterScales[i] * parameterScales[j]));
            }
        }
        return normalizedP;
    }

    public static RealMatrix unnormalizeCovarianceMatrix(RealMatrix normalizedP, double[] parameterScales) {
        int nbParams = normalizedP.getRowDimension();
        RealMatrix physicalP = MatrixUtils.createRealMatrix((int)nbParams, (int)nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                physicalP.setEntry(i, j, normalizedP.getEntry(i, j) * parameterScales[i] * parameterScales[j]);
            }
        }
        return physicalP;
    }

    public static RealMatrix unnormalizeStateTransitionMatrix(RealMatrix normalizedSTM, double[] parameterScales) {
        int nbParams = normalizedSTM.getRowDimension();
        RealMatrix physicalSTM = MatrixUtils.createRealMatrix((int)nbParams, (int)nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                physicalSTM.setEntry(i, j, normalizedSTM.getEntry(i, j) * parameterScales[i] / parameterScales[j]);
            }
        }
        return physicalSTM;
    }

    public static RealMatrix unnormalizeMeasurementJacobian(RealMatrix normalizedH, double[] parameterScales, double[] sigmas) {
        int nbLine = normalizedH.getRowDimension();
        int nbCol = normalizedH.getColumnDimension();
        RealMatrix physicalH = MatrixUtils.createRealMatrix((int)nbLine, (int)nbCol);
        for (int i = 0; i < nbLine; ++i) {
            for (int j = 0; j < nbCol; ++j) {
                physicalH.setEntry(i, j, normalizedH.getEntry(i, j) * sigmas[i] / parameterScales[j]);
            }
        }
        return physicalH;
    }

    public static RealMatrix unnormalizeInnovationCovarianceMatrix(RealMatrix normalizedS, double[] sigmas) {
        int nbMeas = sigmas.length;
        RealMatrix physicalS = MatrixUtils.createRealMatrix((int)nbMeas, (int)nbMeas);
        for (int i = 0; i < nbMeas; ++i) {
            for (int j = 0; j < nbMeas; ++j) {
                physicalS.setEntry(i, j, normalizedS.getEntry(i, j) * sigmas[i] * sigmas[j]);
            }
        }
        return physicalS;
    }

    public static RealMatrix unnormalizeKalmanGainMatrix(RealMatrix normalizedK, double[] parameterScales, double[] sigmas) {
        int nbLine = normalizedK.getRowDimension();
        int nbCol = normalizedK.getColumnDimension();
        RealMatrix physicalK = MatrixUtils.createRealMatrix((int)nbLine, (int)nbCol);
        for (int i = 0; i < nbLine; ++i) {
            for (int j = 0; j < nbCol; ++j) {
                physicalK.setEntry(i, j, normalizedK.getEntry(i, j) * parameterScales[i] / sigmas[j]);
            }
        }
        return physicalK;
    }
}

