/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanEstimatorUtil;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

class KalmanEstimationCommon
implements KalmanEstimation {
    private final List<PropagatorBuilder> builders;
    private final ParameterDriversList allEstimatedOrbitalParameters;
    private final ParameterDriversList allEstimatedPropagationParameters;
    private final ParameterDriversList[] estimatedOrbitalParameters;
    private final ParameterDriversList[] estimatedPropagationParameters;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final int[] orbitsStartColumns;
    private final int[] orbitsEndColumns;
    private final Map<String, Integer> propagationParameterColumns;
    private final Map<String, Integer> measurementParameterColumns;
    private final List<CovarianceMatrixProvider> covarianceMatricesProviders;
    private final CovarianceMatrixProvider measurementProcessNoiseMatrix;
    private final int[][] covarianceIndirection;
    private final double[] scale;
    private ProcessEstimate correctedEstimate;
    private int currentMeasurementNumber;
    private final AbsoluteDate referenceDate;
    private AbsoluteDate currentDate;
    private final SpacecraftState[] predictedSpacecraftStates;
    private final SpacecraftState[] correctedSpacecraftStates;
    private EstimatedMeasurement<?> predictedMeasurement;
    private EstimatedMeasurement<?> correctedMeasurement;

    /*
     * WARNING - void declaration
     */
    protected KalmanEstimationCommon(List<PropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        void var12_56;
        void var9_26;
        this.builders = propagatorBuilders;
        this.estimatedMeasurementsParameters = estimatedMeasurementParameters;
        this.measurementParameterColumns = new HashMap<String, Integer>(this.estimatedMeasurementsParameters.getDrivers().size());
        this.currentMeasurementNumber = 0;
        this.currentDate = this.referenceDate = propagatorBuilders.get(0).getInitialOrbitDate();
        HashMap<String, Integer> orbitalParameterColumns = new HashMap<String, Integer>(6 * this.builders.size());
        this.orbitsStartColumns = new int[this.builders.size()];
        this.orbitsEndColumns = new int[this.builders.size()];
        int columns = 0;
        this.allEstimatedOrbitalParameters = new ParameterDriversList();
        this.estimatedOrbitalParameters = new ParameterDriversList[this.builders.size()];
        for (int k = 0; k < this.builders.size(); ++k) {
            this.estimatedOrbitalParameters[k] = new ParameterDriversList();
            this.orbitsStartColumns[k] = columns;
            String suffix = propagatorBuilders.size() > 1 ? "[" + k + "]" : null;
            for (ParameterDriver parameterDriver : this.builders.get(k).getOrbitalParametersDrivers().getDrivers()) {
                if (parameterDriver.getReferenceDate() == null) {
                    parameterDriver.setReferenceDate(this.currentDate);
                }
                if (suffix != null && !parameterDriver.getName().endsWith(suffix)) {
                    parameterDriver.setName(parameterDriver.getName() + suffix);
                }
                if (!parameterDriver.isSelected()) continue;
                this.allEstimatedOrbitalParameters.add(parameterDriver);
                this.estimatedOrbitalParameters[k].add(parameterDriver);
                orbitalParameterColumns.put(parameterDriver.getName(), columns++);
            }
            this.orbitsEndColumns[k] = columns;
        }
        this.allEstimatedPropagationParameters = new ParameterDriversList();
        this.estimatedPropagationParameters = new ParameterDriversList[this.builders.size()];
        ArrayList<String> estimatedPropagationParametersNames = new ArrayList<String>();
        for (int k = 0; k < this.builders.size(); ++k) {
            this.estimatedPropagationParameters[k] = new ParameterDriversList();
            for (ParameterDriver parameterDriver : this.builders.get(k).getPropagationParametersDrivers().getDrivers()) {
                if (parameterDriver.getReferenceDate() == null) {
                    parameterDriver.setReferenceDate(this.currentDate);
                }
                if (!parameterDriver.isSelected()) continue;
                this.allEstimatedPropagationParameters.add(parameterDriver);
                this.estimatedPropagationParameters[k].add(parameterDriver);
                String driverName = parameterDriver.getName();
                if (estimatedPropagationParametersNames.contains(driverName)) continue;
                estimatedPropagationParametersNames.add(driverName);
            }
        }
        estimatedPropagationParametersNames.sort(Comparator.naturalOrder());
        this.propagationParameterColumns = new HashMap<String, Integer>(estimatedPropagationParametersNames.size());
        for (String string : estimatedPropagationParametersNames) {
            this.propagationParameterColumns.put(string, columns);
            ++columns;
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            this.measurementParameterColumns.put(parameterDriver.getName(), columns);
            ++columns;
        }
        this.covarianceMatricesProviders = covarianceMatricesProviders;
        this.measurementProcessNoiseMatrix = measurementProcessNoiseMatrix;
        this.covarianceIndirection = new int[this.builders.size()][columns];
        for (int k = 0; k < this.covarianceIndirection.length; ++k) {
            Integer c;
            ParameterDriversList parameterDriversList = this.builders.get(k).getOrbitalParametersDrivers();
            ParameterDriversList parameterDriversList2 = this.builders.get(k).getPropagationParametersDrivers();
            Arrays.fill(this.covarianceIndirection[k], -1);
            int i = 0;
            for (ParameterDriver parameterDriver : parameterDriversList.getDrivers()) {
                c = (Integer)orbitalParameterColumns.get(parameterDriver.getName());
                if (c == null) continue;
                this.covarianceIndirection[k][i++] = c;
            }
            for (ParameterDriver parameterDriver : parameterDriversList2.getDrivers()) {
                c = this.propagationParameterColumns.get(parameterDriver.getName());
                if (c == null) continue;
                this.covarianceIndirection[k][i++] = c;
            }
            for (ParameterDriver parameterDriver : estimatedMeasurementParameters.getDrivers()) {
                c = this.measurementParameterColumns.get(parameterDriver.getName());
                if (c == null) continue;
                this.covarianceIndirection[k][i++] = c;
            }
        }
        this.scale = new double[columns];
        int index = 0;
        for (ParameterDriver parameterDriver : this.allEstimatedOrbitalParameters.getDrivers()) {
            this.scale[index++] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.allEstimatedPropagationParameters.getDrivers()) {
            this.scale[index++] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            this.scale[index++] = parameterDriver.getScale();
        }
        this.predictedSpacecraftStates = new SpacecraftState[this.builders.size()];
        boolean bl = false;
        while (var9_26 < this.builders.size()) {
            this.predictedSpacecraftStates[var9_26] = this.builders.get((int)var9_26).buildPropagator().getInitialState();
            ++var9_26;
        }
        this.correctedSpacecraftStates = (SpacecraftState[])this.predictedSpacecraftStates.clone();
        RealVector realVector = MatrixUtils.createRealVector((int)columns);
        boolean bl2 = false;
        for (ParameterDriver parameterDriver : this.allEstimatedOrbitalParameters.getDrivers()) {
            void var10_40;
            realVector.setEntry((int)(++var10_40), parameterDriver.getNormalizedValue());
        }
        for (ParameterDriver parameterDriver : this.allEstimatedPropagationParameters.getDrivers()) {
            void var10_41;
            realVector.setEntry((int)(++var10_41), parameterDriver.getNormalizedValue());
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            void var10_42;
            realVector.setEntry((int)(++var10_42), parameterDriver.getNormalizedValue());
        }
        RealMatrix physicalProcessNoise = MatrixUtils.createRealMatrix((int)columns, (int)columns);
        boolean bl3 = false;
        while (var12_56 < covarianceMatricesProviders.size()) {
            int n = estimatedMeasurementParameters.getNbParams();
            int nbDyn = this.orbitsEndColumns[var12_56] - this.orbitsStartColumns[var12_56] + this.estimatedPropagationParameters[var12_56].getNbParams();
            RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(nbDyn + n), (int)(nbDyn + n));
            if (nbDyn > 0) {
                RealMatrix noiseP = covarianceMatricesProviders.get((int)var12_56).getInitialCovarianceMatrix(this.correctedSpacecraftStates[var12_56]);
                if (measurementProcessNoiseMatrix == null && noiseP.getRowDimension() != nbDyn + n) {
                    throw new OrekitException((Localizable)OrekitMessages.WRONG_PROCESS_COVARIANCE_DIMENSION, nbDyn + n, noiseP.getRowDimension());
                }
                if (measurementProcessNoiseMatrix != null && noiseP.getRowDimension() != nbDyn) {
                    throw new OrekitException((Localizable)OrekitMessages.WRONG_PROCESS_COVARIANCE_DIMENSION, nbDyn, noiseP.getRowDimension());
                }
                noiseK.setSubMatrix(noiseP.getData(), 0, 0);
            }
            if (measurementProcessNoiseMatrix != null) {
                RealMatrix noiseM = measurementProcessNoiseMatrix.getInitialCovarianceMatrix(this.correctedSpacecraftStates[var12_56]);
                if (noiseM.getRowDimension() != n) {
                    throw new OrekitException((Localizable)OrekitMessages.WRONG_MEASUREMENT_COVARIANCE_DIMENSION, n, noiseM.getRowDimension());
                }
                noiseK.setSubMatrix(noiseM.getData(), nbDyn, nbDyn);
            }
            KalmanEstimatorUtil.checkDimension(noiseK.getRowDimension(), this.builders.get((int)var12_56).getOrbitalParametersDrivers(), this.builders.get((int)var12_56).getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
            int[] indK = this.covarianceIndirection[var12_56];
            for (int i = 0; i < indK.length; ++i) {
                if (indK[i] < 0) continue;
                for (int j = 0; j < indK.length; ++j) {
                    if (indK[j] < 0) continue;
                    physicalProcessNoise.setEntry(indK[i], indK[j], noiseK.getEntry(i, j));
                }
            }
            ++var12_56;
        }
        RealMatrix realMatrix = KalmanEstimatorUtil.normalizeCovarianceMatrix(physicalProcessNoise, this.scale);
        this.correctedEstimate = new ProcessEstimate(0.0, realVector, realMatrix);
    }

    @Override
    public RealMatrix getPhysicalStateTransitionMatrix() {
        return this.correctedEstimate.getStateTransitionMatrix() == null ? null : KalmanEstimatorUtil.unnormalizeStateTransitionMatrix(this.correctedEstimate.getStateTransitionMatrix(), this.scale);
    }

    @Override
    public RealMatrix getPhysicalMeasurementJacobian() {
        return this.correctedEstimate.getMeasurementJacobian() == null ? null : KalmanEstimatorUtil.unnormalizeMeasurementJacobian(this.correctedEstimate.getMeasurementJacobian(), this.scale, this.correctedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    @Override
    public RealMatrix getPhysicalInnovationCovarianceMatrix() {
        return this.correctedEstimate.getInnovationCovariance() == null ? null : KalmanEstimatorUtil.unnormalizeInnovationCovarianceMatrix(this.correctedEstimate.getInnovationCovariance(), this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    @Override
    public RealMatrix getPhysicalKalmanGain() {
        return this.correctedEstimate.getKalmanGain() == null ? null : KalmanEstimatorUtil.unnormalizeKalmanGainMatrix(this.correctedEstimate.getKalmanGain(), this.scale, this.correctedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation());
    }

    @Override
    public SpacecraftState[] getPredictedSpacecraftStates() {
        return (SpacecraftState[])this.predictedSpacecraftStates.clone();
    }

    @Override
    public SpacecraftState[] getCorrectedSpacecraftStates() {
        return (SpacecraftState[])this.correctedSpacecraftStates.clone();
    }

    @Override
    public int getCurrentMeasurementNumber() {
        return this.currentMeasurementNumber;
    }

    @Override
    public AbsoluteDate getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public EstimatedMeasurement<?> getPredictedMeasurement() {
        return this.predictedMeasurement;
    }

    @Override
    public EstimatedMeasurement<?> getCorrectedMeasurement() {
        return this.correctedMeasurement;
    }

    @Override
    public RealVector getPhysicalEstimatedState() {
        ArrayRealVector physicalEstimatedState = new ArrayRealVector(this.scale.length);
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        return physicalEstimatedState;
    }

    @Override
    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        return KalmanEstimatorUtil.unnormalizeCovarianceMatrix(this.correctedEstimate.getCovariance(), this.scale);
    }

    @Override
    public ParameterDriversList getEstimatedOrbitalParameters() {
        return this.allEstimatedOrbitalParameters;
    }

    @Override
    public ParameterDriversList getEstimatedPropagationParameters() {
        return this.allEstimatedPropagationParameters;
    }

    @Override
    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.estimatedMeasurementsParameters;
    }

    public ProcessEstimate getEstimate() {
        return this.correctedEstimate;
    }

    public List<PropagatorBuilder> getBuilders() {
        return this.builders;
    }

    public Propagator[] getEstimatedPropagators() {
        Propagator[] propagators = new Propagator[this.getBuilders().size()];
        for (int k = 0; k < this.getBuilders().size(); ++k) {
            propagators[k] = this.getBuilders().get(k).buildPropagator();
        }
        return propagators;
    }

    protected RealMatrix getNormalizedProcessNoise(int stateDimension) {
        RealMatrix physicalProcessNoise = MatrixUtils.createRealMatrix((int)stateDimension, (int)stateDimension);
        for (int k = 0; k < this.covarianceMatricesProviders.size(); ++k) {
            int nbMeas = this.estimatedMeasurementsParameters.getNbParams();
            int nbDyn = this.orbitsEndColumns[k] - this.orbitsStartColumns[k] + this.estimatedPropagationParameters[k].getNbParams();
            RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(nbDyn + nbMeas), (int)(nbDyn + nbMeas));
            if (nbDyn > 0) {
                RealMatrix noiseP = this.covarianceMatricesProviders.get(k).getProcessNoiseMatrix(this.correctedSpacecraftStates[k], this.predictedSpacecraftStates[k]);
                if (this.measurementProcessNoiseMatrix == null && noiseP.getRowDimension() != nbDyn + nbMeas) {
                    throw new OrekitException((Localizable)OrekitMessages.WRONG_PROCESS_COVARIANCE_DIMENSION, nbDyn + nbMeas, noiseP.getRowDimension());
                }
                if (this.measurementProcessNoiseMatrix != null && noiseP.getRowDimension() != nbDyn) {
                    throw new OrekitException((Localizable)OrekitMessages.WRONG_PROCESS_COVARIANCE_DIMENSION, nbDyn, noiseP.getRowDimension());
                }
                noiseK.setSubMatrix(noiseP.getData(), 0, 0);
            }
            if (this.measurementProcessNoiseMatrix != null) {
                RealMatrix noiseM = this.measurementProcessNoiseMatrix.getProcessNoiseMatrix(this.correctedSpacecraftStates[k], this.predictedSpacecraftStates[k]);
                if (noiseM.getRowDimension() != nbMeas) {
                    throw new OrekitException((Localizable)OrekitMessages.WRONG_MEASUREMENT_COVARIANCE_DIMENSION, nbMeas, noiseM.getRowDimension());
                }
                noiseK.setSubMatrix(noiseM.getData(), nbDyn, nbDyn);
            }
            KalmanEstimatorUtil.checkDimension(noiseK.getRowDimension(), this.builders.get(k).getOrbitalParametersDrivers(), this.builders.get(k).getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
            int[] indK = this.covarianceIndirection[k];
            for (int i = 0; i < indK.length; ++i) {
                if (indK[i] < 0) continue;
                for (int j = 0; j < indK.length; ++j) {
                    if (indK[j] < 0) continue;
                    physicalProcessNoise.setEntry(indK[i], indK[j], noiseK.getEntry(i, j));
                }
            }
        }
        return KalmanEstimatorUtil.normalizeCovarianceMatrix(physicalProcessNoise, this.scale);
    }

    protected int[] getOrbitsStartColumns() {
        return this.orbitsStartColumns;
    }

    protected Map<String, Integer> getPropagationParameterColumns() {
        return this.propagationParameterColumns;
    }

    protected Map<String, Integer> getMeasurementParameterColumns() {
        return this.measurementParameterColumns;
    }

    protected ParameterDriversList[] getEstimatedPropagationParametersArray() {
        return this.estimatedPropagationParameters;
    }

    protected ParameterDriversList[] getEstimatedOrbitalParametersArray() {
        return this.estimatedOrbitalParameters;
    }

    protected int[][] getCovarianceIndirection() {
        return this.covarianceIndirection;
    }

    protected double[] getScale() {
        return this.scale;
    }

    protected ProcessEstimate getCorrectedEstimate() {
        return this.correctedEstimate;
    }

    protected void setCorrectedEstimate(ProcessEstimate correctedEstimate) {
        this.correctedEstimate = correctedEstimate;
    }

    protected AbsoluteDate getReferenceDate() {
        return this.referenceDate;
    }

    protected void incrementCurrentMeasurementNumber() {
        ++this.currentMeasurementNumber;
    }

    public void setCurrentDate(AbsoluteDate currentDate) {
        this.currentDate = currentDate;
    }

    protected void setCorrectedSpacecraftState(SpacecraftState correctedSpacecraftState, int index) {
        this.correctedSpacecraftStates[index] = correctedSpacecraftState;
    }

    protected void setPredictedSpacecraftState(SpacecraftState predictedSpacecraftState, int index) {
        this.predictedSpacecraftStates[index] = predictedSpacecraftState;
    }

    protected void setPredictedMeasurement(EstimatedMeasurement<?> predictedMeasurement) {
        this.predictedMeasurement = predictedMeasurement;
    }

    protected void setCorrectedMeasurement(EstimatedMeasurement<?> correctedMeasurement) {
        this.correctedMeasurement = correctedMeasurement;
    }
}

