/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public abstract class AbstractKalmanEstimator {
    private final List<? extends PropagatorBuilder> builders;

    protected AbstractKalmanEstimator(List<? extends PropagatorBuilder> builders) {
        this.builders = builders;
    }

    public ParameterDriversList getOrbitalParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (int i = 0; i < this.builders.size(); ++i) {
            String suffix = this.builders.size() > 1 ? "[" + i + "]" : null;
            for (ParameterDriver parameterDriver : this.builders.get(i).getOrbitalParametersDrivers().getDrivers()) {
                if (!parameterDriver.isSelected() && estimatedOnly) continue;
                if (suffix != null && !parameterDriver.getName().endsWith(suffix)) {
                    parameterDriver.setName(parameterDriver.getName() + suffix);
                }
                estimated.add(parameterDriver);
            }
        }
        return estimated;
    }

    public ParameterDriversList getPropagationParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (PropagatorBuilder propagatorBuilder : this.builders) {
            for (ParameterDriversList.DelegatingDriver delegating : propagatorBuilder.getPropagationParametersDrivers().getDrivers()) {
                if (!delegating.isSelected() && estimatedOnly) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    estimated.add(driver);
                }
            }
        }
        return estimated;
    }

    public int getCurrentMeasurementNumber() {
        return this.getKalmanEstimation().getCurrentMeasurementNumber();
    }

    public AbsoluteDate getCurrentDate() {
        return this.getKalmanEstimation().getCurrentDate();
    }

    public RealVector getPhysicalEstimatedState() {
        return this.getKalmanEstimation().getPhysicalEstimatedState();
    }

    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        return this.getKalmanEstimation().getPhysicalEstimatedCovarianceMatrix();
    }

    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.getKalmanEstimation().getEstimatedMeasurementsParameters();
    }

    protected abstract KalmanEstimation getKalmanEstimation();
}

