/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.TimeSpanMap;

public class TurnAroundRangeIonosphericDelayModifier
implements EstimationModifier<TurnAroundRange> {
    private final IonosphericModel ionoModel;
    private final double frequency;

    public TurnAroundRangeIonosphericDelayModifier(IonosphericModel model, double freq) {
        this.ionoModel = model;
        this.frequency = freq;
    }

    private double rangeErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        return this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters(state.getDate()));
    }

    private <T extends CalculusFieldElement<T>> T rangeErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        return (T)this.ionoModel.pathDelay(state, baseFrame, this.frequency, (CalculusFieldElement[])parameters);
    }

    private double[][] rangeErrorJacobianState(double[] derivatives) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        System.arraycopy(derivatives, 0, finiteDifferencesJacobian[0], 0, 6);
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver, AbsoluteDate date) {
                return TurnAroundRangeIonosphericDelayModifier.this.rangeErrorIonosphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver, state.getDate());
    }

    private double[] rangeErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        return Arrays.copyOfRange(derivatives, freeStateParameters, derivatives.length);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<TurnAroundRange> estimated) {
        TurnAroundRange measurement = estimated.getObservedMeasurement();
        GroundStation primaryStation = measurement.getPrimaryStation();
        GroundStation secondaryStation = measurement.getSecondaryStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] newValue = estimated.getEstimatedValue();
        double primaryDelay = this.rangeErrorIonosphericModel(primaryStation, state);
        double secondaryDelay = this.rangeErrorIonosphericModel(secondaryStation, state);
        newValue[0] = newValue[0] + primaryDelay + secondaryDelay;
        estimated.modifyEstimatedValue(this, newValue);
    }

    @Override
    public void modify(EstimatedMeasurement<TurnAroundRange> estimated) {
        double parameterDerivative;
        TurnAroundRange measurement = (TurnAroundRange)estimated.getObservedMeasurement();
        GroundStation primaryStation = measurement.getPrimaryStation();
        GroundStation secondaryStation = measurement.getSecondaryStation();
        SpacecraftState state = estimated.getStates()[0];
        ModifierGradientConverter converter = new ModifierGradientConverter(state, 6, new FrameAlignedProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.ionoModel);
        Gradient[] gParameters = converter.getParametersAtStateDate(gState, this.ionoModel);
        Gradient primaryGDelay = (Gradient)this.rangeErrorIonosphericModel(primaryStation, gState, (CalculusFieldElement[])gParameters);
        Gradient secondaryGDelay = (Gradient)this.rangeErrorIonosphericModel(secondaryStation, gState, (CalculusFieldElement[])gParameters);
        double[] primaryDerivatives = primaryGDelay.getGradient();
        double[] secondaryDerivatives = secondaryGDelay.getGradient();
        double[][] primaryDjac = this.rangeErrorJacobianState(primaryDerivatives);
        double[][] secondaryDjac = this.rangeErrorJacobianState(secondaryDerivatives);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + (primaryDjac[irow][jcol] + secondaryDjac[irow][jcol]);
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int indexPrimary = 0;
        for (ParameterDriver parameterDriver : this.getParametersDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = parameterDriver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                double parameterDerivative2 = estimated.getParameterDerivatives(parameterDriver, span.getStart())[0];
                double[] derivatives = this.rangeErrorParameterDerivative(primaryDerivatives, converter.getFreeStateParameters());
                estimated.setParameterDerivatives(parameterDriver, span.getStart(), parameterDerivative2 += derivatives[indexPrimary]);
                ++indexPrimary;
            }
        }
        int indexSecondary = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                double[] derivatives = this.rangeErrorParameterDerivative(secondaryDerivatives, converter.getFreeStateParameters());
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += derivatives[indexSecondary]);
                ++indexSecondary;
            }
        }
        for (ParameterDriver driver : Arrays.asList(primaryStation.getClockOffsetDriver(), primaryStation.getEastOffsetDriver(), primaryStation.getNorthOffsetDriver(), primaryStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += this.rangeErrorParameterDerivative(primaryStation, driver, state));
            }
        }
        for (ParameterDriver driver : Arrays.asList(secondaryStation.getEastOffsetDriver(), secondaryStation.getNorthOffsetDriver(), secondaryStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += this.rangeErrorParameterDerivative(secondaryStation, driver, state));
            }
        }
        double[] dArray = estimated.getEstimatedValue();
        dArray[0] = dArray[0] + primaryGDelay.getReal() + secondaryGDelay.getReal();
        estimated.modifyEstimatedValue(this, dArray);
    }
}

