/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TDOA;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.estimation.measurements.modifiers.TDOAModifierUtil;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelAdapter;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public class TDOATroposphericDelayModifier
implements EstimationModifier<TDOA> {
    private final TroposphericModel tropoModel;

    @Deprecated
    public TDOATroposphericDelayModifier(DiscreteTroposphericModel model) {
        this(new TroposphericModelAdapter(model));
    }

    public TDOATroposphericDelayModifier(TroposphericModel model) {
        this.tropoModel = model;
    }

    private double timeErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPosition();
        TrackingCoordinates trackingCoordinates = station.getBaseFrame().getTrackingCoordinates(position, state.getFrame(), state.getDate());
        if (trackingCoordinates.getElevation() > 0.0) {
            double delay = this.tropoModel.pathDelay(trackingCoordinates, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), this.tropoModel.getParameters(state.getDate()), state.getDate()).getDelay();
            return delay / 2.99792458E8;
        }
        return 0.0;
    }

    private <T extends CalculusFieldElement<T>> T timeErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldVector3D<T> pos = state.getPosition();
        FieldTrackingCoordinates<T> trackingCoordinates = station.getBaseFrame().getTrackingCoordinates(pos, state.getFrame(), state.getDate());
        if (trackingCoordinates.getElevation().getReal() > 0.0) {
            Object delay = this.tropoModel.pathDelay(trackingCoordinates, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), (CalculusFieldElement[])parameters, state.getDate()).getDelay();
            return (T)((CalculusFieldElement)delay.divide(2.99792458E8));
        }
        return (T)zero;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<TDOA> estimated) {
        TDOA measurement = estimated.getObservedMeasurement();
        GroundStation primeStation = measurement.getPrimeStation();
        GroundStation secondStation = measurement.getSecondStation();
        TDOAModifierUtil.modifyWithoutDerivatives(estimated, primeStation, secondStation, this::timeErrorTroposphericModel, this);
    }

    @Override
    public void modify(EstimatedMeasurement<TDOA> estimated) {
        TDOA measurement = (TDOA)estimated.getObservedMeasurement();
        GroundStation primeStation = measurement.getPrimeStation();
        GroundStation secondStation = measurement.getSecondStation();
        SpacecraftState state = estimated.getStates()[0];
        TDOAModifierUtil.modify(estimated, this.tropoModel, new ModifierGradientConverter(state, 6, new FrameAlignedProvider(state.getFrame())), primeStation, secondStation, this::timeErrorTroposphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, timeErrorTroposphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((TDOATroposphericDelayModifier)this), this);
    }
}

