/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffect;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversProvider;
import org.orekit.utils.TimeSpanMap;

class TDOAModifierUtil {
    private TDOAModifierUtil() {
    }

    @Deprecated
    public static <T extends ObservedMeasurement<T>> void modifyWithoutDerivatives(EstimatedMeasurementBase<T> estimated, GroundStation primeStation, GroundStation secondStation, ParametricModelEffect modelEffect) {
        TDOAModifierUtil.modifyWithoutDerivatives(estimated, primeStation, secondStation, modelEffect, null);
    }

    public static <T extends ObservedMeasurement<T>> void modifyWithoutDerivatives(EstimatedMeasurementBase<T> estimated, GroundStation primeStation, GroundStation secondStation, ParametricModelEffect modelEffect, EstimationModifier<T> modifier) {
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        double primeDelay = modelEffect.evaluate(primeStation, state);
        double secondDelay = modelEffect.evaluate(secondStation, state);
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + primeDelay;
        newValue[0] = newValue[0] - secondDelay;
        estimated.modifyEstimatedValue(modifier, newValue);
    }

    @Deprecated
    public static <T extends ObservedMeasurement<T>> void modify(EstimatedMeasurement<T> estimated, ParameterDriversProvider parametricModel, AbstractGradientConverter converter, GroundStation primeStation, GroundStation secondStation, ParametricModelEffect modelEffect, ParametricModelEffectGradient modelEffectGradient) {
        TDOAModifierUtil.modify(estimated, parametricModel, converter, primeStation, secondStation, modelEffect, modelEffectGradient, null);
    }

    public static <T extends ObservedMeasurement<T>> void modify(EstimatedMeasurement<T> estimated, ParameterDriversProvider parametricModel, AbstractGradientConverter converter, GroundStation primeStation, GroundStation secondStation, ParametricModelEffect modelEffect, ParametricModelEffectGradient modelEffectGradient, EstimationModifier<T> modifier) {
        double parameterDerivative;
        TimeSpanMap.Span<String> span;
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        FieldSpacecraftState<Gradient> gState = converter.getState(parametricModel);
        Gradient[] gParameters = converter.getParameters(gState, parametricModel);
        Gradient primeGDelay = modelEffectGradient.evaluate(primeStation, gState, gParameters);
        Gradient secondGDelay = modelEffectGradient.evaluate(secondStation, gState, gParameters);
        double[] primeDerivatives = primeGDelay.getGradient();
        double[] secondDerivatives = secondGDelay.getGradient();
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
            double[] dArray = stateDerivatives[0];
            int n = jcol;
            dArray[n] = dArray[n] + primeDerivatives[jcol];
            double[] dArray2 = stateDerivatives[0];
            int n2 = jcol;
            dArray2[n2] = dArray2[n2] - secondDerivatives[jcol];
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : parametricModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                parameterDerivative += primeDerivatives[index + converter.getFreeStateParameters()];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative -= secondDerivatives[index + converter.getFreeStateParameters()]);
                ++index;
            }
        }
        for (ParameterDriver driver : Arrays.asList(primeStation.getClockOffsetDriver(), primeStation.getEastOffsetDriver(), primeStation.getNorthOffsetDriver(), primeStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            for (span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += Differentiation.differentiate((d, t) -> modelEffect.evaluate(primeStation, state), 3, 10.0 * driver.getScale()).value(driver, state.getDate()));
            }
        }
        for (ParameterDriver driver : Arrays.asList(secondStation.getClockOffsetDriver(), secondStation.getEastOffsetDriver(), secondStation.getNorthOffsetDriver(), secondStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            for (span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative -= Differentiation.differentiate((d, t) -> modelEffect.evaluate(secondStation, state), 3, 10.0 * driver.getScale()).value(driver, state.getDate()));
            }
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + primeGDelay.getReal();
        newValue[0] = newValue[0] - secondGDelay.getReal();
        estimated.modifyEstimatedValue(modifier, newValue);
    }
}

