/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TDOA;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.estimation.measurements.modifiers.TDOAModifierUtil;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class TDOAIonosphericDelayModifier
implements EstimationModifier<TDOA> {
    private final IonosphericModel ionoModel;
    private final double frequency;

    public TDOAIonosphericDelayModifier(IonosphericModel model, double freq) {
        this.ionoModel = model;
        this.frequency = freq;
    }

    private double timeErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        double delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters(state.getDate()));
        return delay / 2.99792458E8;
    }

    private <T extends CalculusFieldElement<T>> T timeErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        CalculusFieldElement delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, (CalculusFieldElement[])parameters);
        return (T)((CalculusFieldElement)delay.divide(2.99792458E8));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<TDOA> estimated) {
        TDOA measurement = estimated.getObservedMeasurement();
        GroundStation primeStation = measurement.getPrimeStation();
        GroundStation secondStation = measurement.getSecondStation();
        TDOAModifierUtil.modifyWithoutDerivatives(estimated, primeStation, secondStation, this::timeErrorIonosphericModel, this);
    }

    @Override
    public void modify(EstimatedMeasurement<TDOA> estimated) {
        TDOA measurement = (TDOA)estimated.getObservedMeasurement();
        GroundStation primeStation = measurement.getPrimeStation();
        GroundStation secondStation = measurement.getSecondStation();
        SpacecraftState state = estimated.getStates()[0];
        TDOAModifierUtil.modify(estimated, this.ionoModel, new ModifierGradientConverter(state, 6, new FrameAlignedProvider(state.getFrame())), primeStation, secondStation, this::timeErrorIonosphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, timeErrorIonosphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((TDOAIonosphericDelayModifier)this), this);
    }
}

