/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.InterSatellitesPhase;
import org.orekit.estimation.measurements.modifiers.AbstractShapiroBaseModifier;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ShapiroInterSatellitePhaseModifier
extends AbstractShapiroBaseModifier
implements EstimationModifier<InterSatellitesPhase> {
    public ShapiroInterSatellitePhaseModifier(double gm) {
        super(gm);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<InterSatellitesPhase> estimated) {
        TimeStampedPVCoordinates[] pv = estimated.getParticipants();
        double correction = this.shapiroCorrection(pv[0], pv[1]);
        double wavelength = estimated.getObservedMeasurement().getWavelength();
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] + correction / wavelength;
        estimated.modifyEstimatedValue(this, newValue);
    }
}

