/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.InterSatellitesPhase;
import org.orekit.estimation.measurements.modifiers.AbstractRelativisticJ2ClockModifier;
import org.orekit.utils.ParameterDriver;

public class RelativisticJ2ClockInterSatellitesPhaseModifier
extends AbstractRelativisticJ2ClockModifier
implements EstimationModifier<InterSatellitesPhase> {
    public RelativisticJ2ClockInterSatellitesPhaseModifier(double gm, double c20, double equatorialRadius) {
        super(gm, c20, equatorialRadius);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<InterSatellitesPhase> estimated) {
        double dtJ2 = this.relativisticJ2Correction(estimated);
        double wavelength = estimated.getObservedMeasurement().getWavelength();
        double cOverLambda = 2.99792458E8 / wavelength;
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] - dtJ2 * cOverLambda;
        estimated.modifyEstimatedValue(this, newValue);
    }
}

