/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.gnss.OneWayGNSSRangeRate;
import org.orekit.estimation.measurements.modifiers.AbstractRelativisticClockOnBoardRangeRateModifier;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.TimeStampedPVCoordinates;

public class RelativisticClockOneWayGNSSRangeRateModifier
extends AbstractRelativisticClockOnBoardRangeRateModifier<OneWayGNSSRangeRate> {
    public RelativisticClockOneWayGNSSRangeRateModifier(double gm) {
        super(gm);
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<OneWayGNSSRangeRate> estimated) {
        SpacecraftState local = estimated.getStates()[0];
        TimeStampedPVCoordinates remote = estimated.getParticipants()[0];
        double rRemote = remote.getPosition().getNorm();
        double vRemote = remote.getVelocity().getNorm();
        double aRemote = 1.0 / (2.0 / rRemote - vRemote * vRemote / this.getGm());
        this.modifyWithoutDerivatives(estimated, local.getA(), local.getPosition().getNorm(), aRemote, rRemote);
    }
}

