/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffect;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversProvider;
import org.orekit.utils.TimeSpanMap;

public class RangeRateModifierUtil {
    private RangeRateModifierUtil() {
    }

    @Deprecated
    public static <T extends ObservedMeasurement<T>> void modifyWithoutDerivatives(EstimatedMeasurementBase<T> estimated, GroundStation station, ParametricModelEffect modelEffect) {
        RangeRateModifierUtil.modifyWithoutDerivatives(estimated, station, modelEffect, null);
    }

    public static <T extends ObservedMeasurement<T>> void modifyWithoutDerivatives(EstimatedMeasurementBase<T> estimated, GroundStation station, ParametricModelEffect modelEffect, EstimationModifier<T> modifier) {
        SpacecraftState state = estimated.getStates()[0];
        double[] newValue = estimated.getEstimatedValue();
        double delay = modelEffect.evaluate(station, state);
        newValue[0] = newValue[0] + delay;
        estimated.modifyEstimatedValue(modifier, newValue);
    }

    @Deprecated
    public static <T extends ObservedMeasurement<T>> void modify(EstimatedMeasurement<T> estimated, ParameterDriversProvider parametricModel, AbstractGradientConverter converter, GroundStation station, ParametricModelEffect modelEffect, ParametricModelEffectGradient modelEffectGradient) {
        RangeRateModifierUtil.modify(estimated, parametricModel, converter, station, modelEffect, modelEffectGradient, null);
    }

    public static <T extends ObservedMeasurement<T>> void modify(EstimatedMeasurement<T> estimated, ParameterDriversProvider parametricModel, AbstractGradientConverter converter, GroundStation station, ParametricModelEffect modelEffect, ParametricModelEffectGradient modelEffectGradient, EstimationModifier<T> modifier) {
        double parameterDerivative;
        TimeSpanMap.Span<String> span;
        SpacecraftState state = estimated.getStates()[0];
        FieldSpacecraftState<Gradient> gState = converter.getState(parametricModel);
        Gradient[] gParameters = converter.getParameters(gState, parametricModel);
        Gradient gDelay = modelEffectGradient.evaluate(station, gState, gParameters);
        double[] derivatives = gDelay.getGradient();
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
            double[] dArray = stateDerivatives[0];
            int n = jcol;
            dArray[n] = dArray[n] + derivatives[jcol];
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : parametricModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += derivatives[index + converter.getFreeStateParameters()]);
                ++index;
            }
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            for (span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += Differentiation.differentiate((d, t) -> modelEffect.evaluate(station, state), 3, 10.0 * driver.getScale()).value(driver, state.getDate()));
            }
        }
        RangeRateModifierUtil.modifyWithoutDerivatives(estimated, station, modelEffect, modifier);
    }
}

