/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.Range;
import org.orekit.estimation.measurements.modifiers.BaseRangeIonosphericDelayModifier;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.estimation.measurements.modifiers.RangeModifierUtil;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.SpacecraftState;

public class RangeIonosphericDelayModifier
extends BaseRangeIonosphericDelayModifier
implements EstimationModifier<Range> {
    public RangeIonosphericDelayModifier(IonosphericModel model, double freq) {
        super(model, freq);
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<Range> estimated) {
        Range measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        RangeModifierUtil.modifyWithoutDerivatives(estimated, station, this::rangeErrorIonosphericModel, this);
    }

    @Override
    public void modify(EstimatedMeasurement<Range> estimated) {
        Range measurement = (Range)estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        RangeModifierUtil.modify(estimated, this.getIonoModel(), new ModifierGradientConverter(state, 6, new FrameAlignedProvider(state.getFrame())), station, this::rangeErrorIonosphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, rangeErrorIonosphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((RangeIonosphericDelayModifier)this), this);
    }
}

