/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelAdapter;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TrackingCoordinates;

public class PhaseTroposphericDelayModifier
implements EstimationModifier<Phase> {
    private final TroposphericModel tropoModel;

    @Deprecated
    public PhaseTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this(new TroposphericModelAdapter(model));
    }

    public PhaseTroposphericDelayModifier(TroposphericModel model) {
        this.tropoModel = model;
    }

    private double phaseErrorTroposphericModel(GroundStation station, SpacecraftState state, double wavelength) {
        TrackingCoordinates trackingCoordinates = station.getBaseFrame().getTrackingCoordinates(state.getPosition(), state.getFrame(), state.getDate());
        if (trackingCoordinates.getElevation() > 0.0) {
            double delay = this.tropoModel.pathDelay(trackingCoordinates, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), this.tropoModel.getParameters(state.getDate()), state.getDate()).getDelay();
            return delay / wavelength;
        }
        return 0.0;
    }

    private <T extends CalculusFieldElement<T>> T phaseErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters, double wavelength) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldTrackingCoordinates<T> trackingCoordinates = station.getBaseFrame().getTrackingCoordinates(state.getPosition(), state.getFrame(), state.getDate());
        if (trackingCoordinates.getElevation().getReal() > 0.0) {
            Object delay = this.tropoModel.pathDelay(trackingCoordinates, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), (CalculusFieldElement[])parameters, state.getDate()).getDelay();
            return (T)((CalculusFieldElement)delay.divide(wavelength));
        }
        return (T)zero;
    }

    private double[][] phaseErrorJacobianState(double[] derivatives) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        System.arraycopy(derivatives, 0, finiteDifferencesJacobian[0], 0, 6);
        return finiteDifferencesJacobian;
    }

    private double phaseErrorParameterDerivative(GroundStation station, ParameterDriver driver, SpacecraftState state, double wavelength) {
        ParameterFunction rangeError = (parameterDriver, date) -> this.phaseErrorTroposphericModel(station, state, wavelength);
        ParameterFunction phaseErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return phaseErrorDerivative.value(driver, state.getDate());
    }

    private double[] phaseErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        return Arrays.copyOfRange(derivatives, freeStateParameters, derivatives.length);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<Phase> estimated) {
        Phase measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] newValue = estimated.getEstimatedValue();
        double delay = this.phaseErrorTroposphericModel(station, state, measurement.getWavelength());
        newValue[0] = newValue[0] + delay;
        estimated.modifyEstimatedValue(this, newValue);
    }

    @Override
    public void modify(EstimatedMeasurement<Phase> estimated) {
        double parameterDerivative;
        TimeSpanMap.Span<String> span;
        Phase measurement = (Phase)estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        ModifierGradientConverter converter = new ModifierGradientConverter(state, 6, new FrameAlignedProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.tropoModel);
        Gradient[] gParameters = converter.getParametersAtStateDate(gState, this.tropoModel);
        Gradient gDelay = (Gradient)this.phaseErrorTroposphericModel(station, gState, (CalculusFieldElement[])gParameters, measurement.getWavelength());
        double[] derivatives = gDelay.getGradient();
        double[][] djac = this.phaseErrorJacobianState(derivatives);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                double[] dDelaydP = this.phaseErrorParameterDerivative(derivatives, converter.getFreeStateParameters());
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += dDelaydP[index]);
                ++index;
            }
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            for (span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDerivative = estimated.getParameterDerivatives(driver, span.getStart())[0];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative += this.phaseErrorParameterDerivative(station, driver, state, measurement.getWavelength()));
            }
        }
        this.modifyWithoutDerivatives((EstimatedMeasurementBase<Phase>)estimated);
    }
}

