/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.modifiers.PhaseCentersOffsetComputer;
import org.orekit.frames.StaticTransform;
import org.orekit.gnss.antenna.FrequencyPattern;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class PhaseCentersOneWayGNSSBaseModifier<T extends AbstractMeasurement<T>> {
    private final PhaseCentersOffsetComputer link;
    private final AttitudeProvider attitudeProvider;

    public PhaseCentersOneWayGNSSBaseModifier(FrequencyPattern receiverPattern, FrequencyPattern emitterPattern, AttitudeProvider attitudeProvider) {
        this.link = new PhaseCentersOffsetComputer(emitterPattern, receiverPattern);
        this.attitudeProvider = attitudeProvider;
    }

    public double oneWayDistanceModification(EstimatedMeasurementBase<T> estimated) {
        TimeStampedPVCoordinates[] phaseParticipants = estimated.getParticipants();
        AbsoluteDate phaseEmissionDate = phaseParticipants[0].getDate();
        AbsoluteDate phaseReceptionDate = phaseParticipants[1].getDate();
        SpacecraftState refStateLocal = estimated.getStates()[0];
        SpacecraftState receptionState = refStateLocal.shiftedBy(phaseReceptionDate.durationFrom(refStateLocal.getDate()));
        StaticTransform receptionSpacecraftToInert = receptionState.toStaticTransform().getInverse();
        CartesianOrbit orbitRemote = new CartesianOrbit(phaseParticipants[0], refStateLocal.getFrame(), receptionState.getMu());
        SpacecraftState refStateRemote = new SpacecraftState((Orbit)orbitRemote, this.attitudeProvider.getAttitude(orbitRemote, orbitRemote.getDate(), orbitRemote.getFrame()));
        SpacecraftState emissionState = refStateRemote.shiftedBy(phaseEmissionDate.durationFrom(refStateRemote.getDate()));
        StaticTransform emissionSpacecraftToInert = emissionState.toStaticTransform().getInverse();
        return this.link.offset(emissionSpacecraftToInert, receptionSpacecraftToInert);
    }
}

