/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.StaticTransform;
import org.orekit.gnss.antenna.FrequencyPattern;

public class PhaseCentersOffsetComputer {
    private final FrequencyPattern emitterPattern;
    private final FrequencyPattern receiverPattern;

    public PhaseCentersOffsetComputer(FrequencyPattern emitterPattern, FrequencyPattern receiverPattern) {
        this.emitterPattern = emitterPattern;
        this.receiverPattern = receiverPattern;
    }

    public double offset(StaticTransform emitterToInert, StaticTransform receiverToInert) {
        Vector3D emitterOrigin = emitterToInert.transformPosition(Vector3D.ZERO);
        Vector3D receiverOrigin = receiverToInert.transformPosition(Vector3D.ZERO);
        Vector3D deltaOrigins = receiverOrigin.subtract((Vector)emitterOrigin);
        Vector3D emitterMean = emitterToInert.transformPosition(this.emitterPattern.getEccentricities());
        Vector3D receiverMean = receiverToInert.transformPosition(this.receiverPattern.getEccentricities());
        Vector3D deltaMeans = receiverMean.subtract((Vector)emitterMean);
        Vector3D emitterLos = emitterToInert.getRotation().applyInverseTo(deltaMeans);
        double emitterPCV = this.emitterPattern.getPhaseCenterVariation(emitterLos);
        Vector3D receiverLos = receiverToInert.getRotation().applyInverseTo(deltaMeans.negate());
        double receiverPCV = this.receiverPattern.getPhaseCenterVariation(receiverLos);
        return deltaMeans.getNorm() - deltaOrigins.getNorm() + emitterPCV + receiverPCV;
    }
}

