/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.InterSatellitesRange;
import org.orekit.estimation.measurements.modifiers.PhaseCentersOffsetComputer;
import org.orekit.frames.StaticTransform;
import org.orekit.gnss.antenna.FrequencyPattern;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class PhaseCentersInterSatellitesBaseModifier<T extends AbstractMeasurement<T>> {
    private final PhaseCentersOffsetComputer uplink;
    private final PhaseCentersOffsetComputer downlink;

    public PhaseCentersInterSatellitesBaseModifier(FrequencyPattern pattern1, FrequencyPattern pattern2) {
        this.uplink = new PhaseCentersOffsetComputer(pattern1, pattern2);
        this.downlink = new PhaseCentersOffsetComputer(pattern2, pattern1);
    }

    public double oneWayDistanceModification(EstimatedMeasurementBase<T> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        AbsoluteDate emissionDate = participants[0].getDate();
        AbsoluteDate receptionDate = participants[1].getDate();
        SpacecraftState localState = estimated.getStates()[0];
        SpacecraftState receptionState = localState.shiftedBy(receptionDate.durationFrom(localState.getDate()));
        StaticTransform receptionSpacecraftToInert = receptionState.toStaticTransform().getInverse();
        SpacecraftState remoteState = estimated.getStates()[1];
        SpacecraftState emissionState = remoteState.shiftedBy(emissionDate.durationFrom(remoteState.getDate()));
        StaticTransform emissionSpacecraftToInert = emissionState.toStaticTransform().getInverse();
        return this.downlink.offset(emissionSpacecraftToInert, receptionSpacecraftToInert);
    }

    public double twoWayDistanceModification(EstimatedMeasurementBase<InterSatellitesRange> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        AbsoluteDate emissionDate = participants[0].getDate();
        AbsoluteDate transitDate = participants[1].getDate();
        AbsoluteDate receptionDate = participants[2].getDate();
        SpacecraftState refState1 = estimated.getStates()[0];
        SpacecraftState receptionState = refState1.shiftedBy(receptionDate.durationFrom(refState1.getDate()));
        StaticTransform receptionSpacecraftToInert = receptionState.toStaticTransform().getInverse();
        SpacecraftState refState2 = estimated.getStates()[1];
        SpacecraftState transitState = refState2.shiftedBy(transitDate.durationFrom(refState2.getDate()));
        StaticTransform transitSpacecraftToInert = transitState.toStaticTransform().getInverse();
        SpacecraftState emissionState = refState1.shiftedBy(emissionDate.durationFrom(refState1.getDate()));
        StaticTransform emissionSpacecraftToInert = emissionState.toStaticTransform().getInverse();
        double uplinkOffset = this.uplink.offset(emissionSpacecraftToInert, transitSpacecraftToInert);
        double downlinkOffset = this.downlink.offset(transitSpacecraftToInert, receptionSpacecraftToInert);
        return 0.5 * (uplinkOffset + downlinkOffset);
    }
}

